package cn.com.duiba.activity.center.biz.service.seconds_kill.impl;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.activity.center.api.dto.seconds_kill.DuibaSecondsKillActivityDto;
import cn.com.duiba.activity.center.biz.dao.seconds_kill.DuibaSecondsKillActivityDao;
import cn.com.duiba.activity.center.biz.entity.seconds_kill.DuibaSecondsKillActivityEntity;
import cn.com.duiba.activity.center.biz.service.seconds_kill.DuibaSecondsKillActivityService;
import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * Created by xuezhaoming on 16/6/12.
 */
@Service
public class DuibaSecondsKillActivityServiceImpl implements DuibaSecondsKillActivityService {

	@Resource
    private DuibaSecondsKillActivityDao duibaSecondsKillActivityDao;

    @Override
    public DuibaSecondsKillActivityDto find(Long id) {
        return BeanUtils.copy(duibaSecondsKillActivityDao.find(id), DuibaSecondsKillActivityDto.class);
    }

    @Override
    public List<AddActivityDto> findAllDuibaSecondKillByAppId(Long appId) {
        return BeanUtils.copyList(duibaSecondsKillActivityDao.findAllDuibaSecondKillByAppId(appId), AddActivityDto.class);
    }

    @Override
    public List<DuibaSecondsKillActivityDto> findAllByIds(List<Long> ids) {
        return BeanUtils.copyList(duibaSecondsKillActivityDao.findAllByIds(ids), DuibaSecondsKillActivityDto.class);
    }

    @Override
    public List<DuibaSecondsKillActivityDto> findAutoOff() {
        return BeanUtils.copyList(duibaSecondsKillActivityDao.findAutoOff(), DuibaSecondsKillActivityDto.class);
    }

    @Override
    public void changeStatus(Long id, Integer status) {
        duibaSecondsKillActivityDao.changeStatus(id, status);
    }

    @Override
    public int updateAutoOffDateNull(Long id) {
        return duibaSecondsKillActivityDao.updateAutoOffDateNull(id);
    }

    @Override
    public void insert(DuibaSecondsKillActivityDto DuibaSecondsKillActivityDto) {
        duibaSecondsKillActivityDao.insert(BeanUtils.copy(DuibaSecondsKillActivityDto, DuibaSecondsKillActivityEntity.class));
    }

    @Override
    public List<DuibaSecondsKillActivityDto> findByPage(Map<String, Object> params) {
        return BeanUtils.copyList(duibaSecondsKillActivityDao.findByPage(params), DuibaSecondsKillActivityDto.class);
    }

    @Override
    public int count() {
        return duibaSecondsKillActivityDao.count();
    }

    @Override
    public int count(Map<String, Object> params) {
        return duibaSecondsKillActivityDao.count(params);
    }

    @Override
    public void deleteById(Long id) {
        duibaSecondsKillActivityDao.deleteById(id);
    }

    @Override
    public void updateSwitches(Long id, Long switches) {
        duibaSecondsKillActivityDao.updateSwitches(id, switches);
    }

    @Override
    public void update(DuibaSecondsKillActivityDto DuibaSecondsKillActivityDto) {
        duibaSecondsKillActivityDao.update(BeanUtils.copy(DuibaSecondsKillActivityDto, DuibaSecondsKillActivityEntity.class));
    }
}
