/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.dao.quizz.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.quizz.QuizzOrdersDao;
import cn.com.duiba.activity.center.biz.dao.quizz.QuizzOrdersStatusChangeDao;
import cn.com.duiba.activity.center.biz.support.TableHelper;
import cn.com.duiba.dcommons.enums.ActivityOrderStatusEnums;
import cn.com.duiba.dcommons.enums.ExchangeStatusEnums;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="quizzOrdersStatusChangeDAO")
public class QuizzOrdersStatusChangeDaoImpl
extends ActivityBaseDao
implements QuizzOrdersStatusChangeDao {
    private static Logger log = LoggerFactory.getLogger(QuizzOrdersStatusChangeDaoImpl.class);
    @Autowired
    private QuizzOrdersDao quizzOrdersDao;

    @Override
    public int updateExchangeStatusToFail(Long consumerId, long id, String error4admin, String error4developer, String error4consumer) {
        try {
            Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
            paramMap.put("id", id);
            paramMap.put("exchangeStatus", ExchangeStatusEnums.ExchangeStatusFail);
            paramMap.put("error4admin", TableHelper.subString(error4admin, 200));
            paramMap.put("error4developer", TableHelper.subString(error4developer, 200));
            paramMap.put("error4consumer", TableHelper.subString(error4consumer, 200));
            int ret = this.update("updateExchangeStatusToFail", paramMap);
            return ret;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return 0;
        }
    }

    @Override
    public int updateExchangeStatusToOverdue(long id, long consumerId, String error4admin, String error4developer, String error4consumer) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        paramMap.put("exchangeStatus", ExchangeStatusEnums.ExchangeStatusOverdue);
        paramMap.put("error4admin", TableHelper.subString(error4admin, 200));
        paramMap.put("error4developer", TableHelper.subString(error4developer, 200));
        paramMap.put("error4consumer", TableHelper.subString(error4consumer, 200));
        return this.update("updateExchangeStatusToOverdue", paramMap);
    }

    @Override
    public int updateStatusToFail(Long consumerId, long id, String error4admin, String error4developer, String error4consumer) {
        try {
            Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
            paramMap.put("id", id);
            paramMap.put("error4admin", TableHelper.subString(error4admin, 200));
            paramMap.put("error4developer", TableHelper.subString(error4developer, 200));
            paramMap.put("error4consumer", TableHelper.subString(error4consumer, 200));
            int ret = this.update("updateStatusToFail", paramMap);
            return ret;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return 0;
        }
    }

    @Override
    public Integer doTakePrize(Long consumerId, Long id) {
        try {
            Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
            paramMap.put("id", id);
            return this.update("doTakePrize", paramMap);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return 0;
        }
    }

    @Override
    public Integer rollbackTakePrize(Long consumerId, Long id) {
        try {
            Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
            paramMap.put("id", id);
            return this.update("rollbackTakePrize", paramMap);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return 0;
        }
    }

    @Override
    public Integer updateLotteryResult(Long consumerId, Long id, Long appItemId, Long itemId, Long prizeId, String prizeName, String prizeType, String prizeFacePrice, Long couponId) {
        try {
            Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
            paramMap.put("id", id);
            paramMap.put("appItemId", appItemId);
            paramMap.put("itemId", itemId);
            paramMap.put("prizeId", prizeId);
            paramMap.put("prizeName", prizeName);
            paramMap.put("prizeType", prizeType);
            paramMap.put("prizeFacePrice", prizeFacePrice);
            paramMap.put("couponId", couponId);
            paramMap.put("status", ActivityOrderStatusEnums.StatusSuccess);
            paramMap.put("exchangeStatus", ExchangeStatusEnums.ExchangeStatusWait);
            return this.update("updateLotteryResult", paramMap);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return 0;
        }
    }

    @Override
    public Integer updateLotteryLuckResult(Long consumerId, Long id, Long appItemId, Long itemId, Long prizeId, String prizeName, String prizeType, String prizeFacePrice, Long couponId) {
        try {
            Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
            paramMap.put("id", id);
            paramMap.put("appItemId", appItemId);
            paramMap.put("itemId", itemId);
            paramMap.put("prizeId", prizeId);
            paramMap.put("prizeName", prizeName);
            paramMap.put("prizeType", prizeType);
            paramMap.put("prizeFacePrice", prizeFacePrice);
            paramMap.put("couponId", couponId);
            paramMap.put("exchangeStatus", ExchangeStatusEnums.ExchangeStatusWait);
            return this.update("updateLotteryLuckResult", paramMap);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return 0;
        }
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.QUIZZ_CONSUMER;
    }
}

