/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.quizz.impl;

import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzOptionsDto;
import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzStockDto;
import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzStockManualChangeDto;
import cn.com.duiba.activity.center.biz.dao.quizz.DuibaQuizzStockDao;
import cn.com.duiba.activity.center.biz.dao.quizz.DuibaQuizzStockManualChangeDao;
import cn.com.duiba.activity.center.biz.entity.quizz.DuibaQuizzStockEntity;
import cn.com.duiba.activity.center.biz.entity.quizz.DuibaQuizzStockManualChangeEntity;
import cn.com.duiba.activity.center.biz.service.quizz.QuizzStockService;
import cn.com.duiba.activity.center.biz.support.copier.quizz.DuibaQuizzStockCopier;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QuizzStockServiceImpl
implements QuizzStockService {
    private static final Logger LOG = LoggerFactory.getLogger(QuizzStockServiceImpl.class);
    @Resource
    private DuibaQuizzStockDao duibaQuizzStockDao;
    @Resource
    private DuibaQuizzStockManualChangeDao duibaQuizzStockManualChangeDao;

    @Override
    public int subStock(Long id, Integer subNumber) {
        if (id == null || id <= 0L || subNumber == null || subNumber.longValue() <= 0L) {
            return 0;
        }
        return this.duibaQuizzStockDao.subStock(id, subNumber);
    }

    @Override
    public int addStock(Long id, Integer addNumber) {
        if (id == null || id <= 0L || addNumber == null || addNumber <= 0) {
            return 0;
        }
        return this.duibaQuizzStockDao.addStock(id, addNumber);
    }

    @Override
    public DuibaQuizzStockDto findRemaining(Long optionId) {
        if (optionId == null || optionId <= 0L) {
            return null;
        }
        DuibaQuizzStockEntity entity = this.duibaQuizzStockDao.findRemaining(optionId);
        return DuibaQuizzStockCopier.entity2Dto(entity);
    }

    @Override
    public DuibaQuizzStockDto findByQuizzOptionId(Long questionOptionId) {
        return (DuibaQuizzStockDto)BeanUtils.copy((Object)((Object)this.duibaQuizzStockDao.findByQuizzOptionId(questionOptionId)), DuibaQuizzStockDto.class);
    }

    @Override
    public List<DuibaQuizzStockDto> findByQuizzOptionIds(List<Long> list) {
        return BeanUtils.copyList(this.duibaQuizzStockDao.findByQuizzOptionIds(list), DuibaQuizzStockDto.class);
    }

    @Override
    public int updateStockAdd(Long id, Integer stockAdd) {
        return this.duibaQuizzStockDao.updateStockAdd(id, stockAdd);
    }

    @Override
    public int updateStockSub(Long id, Integer stockSub) {
        return this.duibaQuizzStockDao.updateStockSub(id, stockSub);
    }

    @Override
    public void add(DuibaQuizzStockDto quizzStockDO) {
        this.duibaQuizzStockDao.add((DuibaQuizzStockEntity)((Object)BeanUtils.copy((Object)quizzStockDO, DuibaQuizzStockEntity.class)));
    }

    @Override
    public void addBatch(List<DuibaQuizzStockDto> list) {
        this.duibaQuizzStockDao.addBatch(BeanUtils.copyList(list, DuibaQuizzStockEntity.class));
    }

    @Override
    @Transactional
    public void updateStockByOptions(DuibaQuizzOptionsDto option) {
        Integer addOrSub = DuibaQuizzStockManualChangeDto.ADD;
        int diff = 0;
        DuibaQuizzStockEntity stockDO = this.duibaQuizzStockDao.findByQuizzOptionId(option.getId());
        if (stockDO == null) {
            stockDO = new DuibaQuizzStockEntity();
            stockDO.setQuizzOptionId(option.getId());
            stockDO.setStock(option.getNewOptionCount());
            this.duibaQuizzStockDao.add(stockDO);
            diff = option.getNewOptionCount();
            addOrSub = DuibaQuizzStockManualChangeDto.ADD;
            if (diff != 0) {
                DuibaQuizzStockDto newStock = (DuibaQuizzStockDto)BeanUtils.copy((Object)((Object)this.duibaQuizzStockDao.findByQuizzOptionId(option.getId())), DuibaQuizzStockDto.class);
                DuibaQuizzStockManualChangeEntity stockManualChangeDO = new DuibaQuizzStockManualChangeEntity();
                stockManualChangeDO.setQuizzStockId(stockDO.getId());
                stockManualChangeDO.setOptionId(option.getId());
                stockManualChangeDO.setBeforeStock(0);
                stockManualChangeDO.setAfterStock(newStock.getStock());
                stockManualChangeDO.setChangeKind(addOrSub);
                stockManualChangeDO.setChangeQuantity(Math.abs(diff));
                this.duibaQuizzStockManualChangeDao.add(stockManualChangeDO);
            }
        }
    }

    @Override
    @Transactional
    public void updateStockByOptions(DuibaQuizzOptionsDto option, DuibaQuizzOptionsDto old) throws Exception {
        Integer addOrSub = DuibaQuizzStockManualChangeDto.ADD;
        int diff = 0;
        DuibaQuizzStockEntity stockDO = this.duibaQuizzStockDao.findByQuizzOptionId(option.getId());
        if (stockDO == null) {
            stockDO = new DuibaQuizzStockEntity();
            stockDO.setQuizzOptionId(option.getId());
            stockDO.setStock(option.getNewOptionCount());
            this.duibaQuizzStockDao.add(stockDO);
            diff = option.getNewOptionCount();
            addOrSub = DuibaQuizzStockManualChangeDto.ADD;
        } else {
            Integer nowCount;
            Integer oldStock = stockDO.getStock();
            diff = (oldStock == null ? 0 : oldStock) - ((nowCount = option.getNewOptionCount()) == null ? 0 : nowCount);
            if (diff == 0) {
                return;
            }
            stockDO.setStock(diff);
            int result = 0;
            if (diff > 0) {
                addOrSub = DuibaQuizzStockManualChangeDto.SUB;
                result = this.duibaQuizzStockDao.updateStockSub(stockDO.getId(), stockDO.getStock());
                if (result != 1) {
                    LOG.error("\u6d4b\u8bd5\u9898\u5956\u9879\u5e93\u5b58\u51cf\u5c11\u9519\u8bef\u4e86\uff01");
                    throw new Exception("\u6d4b\u8bd5\u9898\u5956\u9879\u5e93\u5b58\u51cf\u5c11\u9519\u8bef\u4e86\uff01");
                }
            } else {
                addOrSub = DuibaQuizzStockManualChangeDto.ADD;
                result = this.duibaQuizzStockDao.updateStockAdd(stockDO.getId(), Math.abs(stockDO.getStock()));
                if (result != 1) {
                    LOG.error("\u6d4b\u8bd5\u9898\u5956\u9879\u5e93\u5b58\u589e\u52a0\u9519\u8bef\u4e86\uff01");
                    throw new Exception("\u6d4b\u8bd5\u9898\u5956\u9879\u5e93\u5b58\u589e\u52a0\u9519\u8bef\u4e86\uff01");
                }
            }
            if (diff != 0) {
                DuibaQuizzStockEntity newStock = this.duibaQuizzStockDao.findByQuizzOptionId(option.getId());
                DuibaQuizzStockManualChangeEntity stockManualChangeDO = new DuibaQuizzStockManualChangeEntity();
                stockManualChangeDO.setQuizzStockId(stockDO.getId());
                stockManualChangeDO.setOptionId(option.getId());
                stockManualChangeDO.setBeforeStock(oldStock);
                stockManualChangeDO.setAfterStock(newStock.getStock());
                stockManualChangeDO.setChangeKind(addOrSub);
                stockManualChangeDO.setChangeQuantity(Math.abs(diff));
                this.duibaQuizzStockManualChangeDao.add(stockManualChangeDO);
            }
        }
    }
}

