/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.remoteservice.impl;

import cn.com.duiba.activity.center.api.dto.ActivityCategoryDto;
import cn.com.duiba.activity.center.api.dto.CategoryActivityDto;
import cn.com.duiba.activity.center.api.remoteservice.RemoteActivityCategoryService;
import cn.com.duiba.activity.center.biz.entity.ActivityCategoryEntity;
import cn.com.duiba.activity.center.biz.entity.ActivityCategoryRelationEntity;
import cn.com.duiba.activity.center.biz.entity.activity.OperatingActivityEntity;
import cn.com.duiba.activity.center.biz.service.ActivityCategoryRelationService;
import cn.com.duiba.activity.center.biz.service.ActivityCategoryService;
import cn.com.duiba.activity.center.biz.service.activity.OperatingActivityService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remoteActivityCategoryService")
public class RemoteActivityCategoryServiceImpl
implements RemoteActivityCategoryService {
    private static final Logger log = LoggerFactory.getLogger(RemoteActivityCategoryServiceImpl.class);
    @Autowired
    private ActivityCategoryService activityCategoryService;
    @Autowired
    private ActivityCategoryRelationService activityCategoryRelationService;
    @Autowired
    private OperatingActivityService operatingActivityService;

    public DubboResult<ActivityCategoryDto> findById(long id) {
        try {
            ActivityCategoryEntity endtity = this.activityCategoryService.findById(id);
            ActivityCategoryDto dto = new ActivityCategoryDto();
            dto.setId(endtity.getId());
            dto.setName(endtity.getName());
            dto.setEnable(endtity.getEnable());
            dto.setContent(endtity.getContent());
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            log.error("findAll", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<CategoryActivityDto>> findAllActivitiesByAppCategory(long appId, long categoryId, int start, int pageSize) {
        try {
            List<ActivityCategoryRelationEntity> acrs = this.activityCategoryRelationService.findByAppCategory(appId, categoryId, start, pageSize);
            ArrayList<CategoryActivityDto> dtos = new ArrayList<CategoryActivityDto>();
            if (acrs != null && acrs.size() > 0) {
                for (ActivityCategoryRelationEntity acr : acrs) {
                    CategoryActivityDto dto = new CategoryActivityDto();
                    OperatingActivityEntity enty = this.operatingActivityService.findById(acr.getOperatingActivityId());
                    dto.setId(acr.getId());
                    dto.setOperatingId(acr.getOperatingActivityId());
                    dto.setPayload(acr.getPayload());
                    dto.setAppId(Long.valueOf(appId));
                    dto.setCategoryId(Long.valueOf(categoryId));
                    dto.setTitle(enty.getTitle());
                    dto.setThumb(enty.getSmallImage());
                    dto.setBanner(enty.getImage());
                    if (enty.getCustomCredits() != null && enty.getCustomCredits() > 0L) {
                        dto.setCredits(enty.getCustomCredits());
                    } else {
                        dto.setCredits(enty.getCredits());
                    }
                    dto.setAppItemId(enty.getAppItemId());
                    dtos.add(dto);
                }
            }
            return DubboResult.successResult(dtos);
        }
        catch (Exception e) {
            log.error("findAllActivitiesByAppCategory error,appId=" + appId + ",categoryId=" + categoryId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

