/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.impl;

import cn.com.duiba.activity.center.api.dto.CategoryActivityDto;
import cn.com.duiba.activity.center.biz.dao.category.ActivityCategoryRelationDao;
import cn.com.duiba.activity.center.biz.entity.ActivityCategoryRelationEntity;
import cn.com.duiba.activity.center.biz.service.ActivityCategoryRelationService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="creditsActivity")
public class ActivityCategoryRelationServiceImpl
implements ActivityCategoryRelationService {
    private static final Logger log = LoggerFactory.getLogger(ActivityCategoryRelationServiceImpl.class);
    @Autowired
    private ActivityCategoryRelationDao activityCategoryRelationDao;

    @Override
    public List<ActivityCategoryRelationEntity> findByAppCategory(long appId, long categoryId) {
        return this.activityCategoryRelationDao.selectByAppCategory(appId, categoryId);
    }

    @Override
    public boolean sortActivities(List<CategoryActivityDto> activities) {
        boolean rs = true;
        try {
            for (CategoryActivityDto dto : activities) {
                if (1 == this.activityCategoryRelationDao.updatePayload(dto.getId(), dto.getPayload())) continue;
                rs = false;
            }
        }
        catch (Exception e) {
            rs = false;
            log.error("\u66f4\u65b0\u6743\u91cd\u503c\u51fa\u9519", (Throwable)e);
        }
        return rs;
    }

    @Override
    public boolean save(ActivityCategoryRelationEntity entity) {
        boolean success = false;
        int rs = this.activityCategoryRelationDao.insert(entity);
        if (rs == 1) {
            success = true;
        }
        return success;
    }

    @Override
    public boolean remove(long operatingActivityId) {
        boolean rs = false;
        try {
            this.activityCategoryRelationDao.deleteByOperatingActivityId(operatingActivityId);
            rs = true;
        }
        catch (Exception e) {
            log.error("activityCategoryRelationDao.deleteByOperatingActivityId(" + operatingActivityId + ") error", (Throwable)e);
            throw e;
        }
        return rs;
    }

    @Override
    public ActivityCategoryRelationEntity findByOperatingActivityId(long operatingActivityId) {
        ActivityCategoryRelationEntity entity = new ActivityCategoryRelationEntity();
        entity.setOperatingActivityId(operatingActivityId);
        List<ActivityCategoryRelationEntity> list = this.activityCategoryRelationDao.selectWithConditions(entity);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<ActivityCategoryRelationEntity> findByAppCategory(long appId, long categoryId, int start, int pageSize) {
        return this.activityCategoryRelationDao.selectByAppCategory(appId, categoryId, start, pageSize);
    }
}

