/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.dao.ngame_con.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.ngame_con.NgameOrdersConsumerDao;
import cn.com.duiba.activity.center.biz.entity.ngame.NgameOrdersEntity;
import cn.com.duiba.activity.center.biz.entity.ngame.NgameOrdersSequenceEntity;
import cn.com.duiba.activity.center.biz.support.TableHelper;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class NgameOrdersConsumerDaoImpl
extends ActivityBaseDao
implements NgameOrdersConsumerDao {
    public Integer countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        return (Integer)this.selectOne("countByConsumerIdAndOperatingActivityId", paramMap);
    }

    public Integer countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        paramMap.put("start", start);
        paramMap.put("end", end);
        return (Integer)this.selectOne("countByConsumerIdAndOperatingActivityIdAndDate", paramMap);
    }

    public Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        return (Integer)this.selectOne("countFreeByConsumerIdAndOperatingActivityId", paramMap);
    }

    public Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        paramMap.put("start", start);
        paramMap.put("end", end);
        return (Integer)this.selectOne("countFreeByConsumerIdAndOperatingActivityIdAndDate", paramMap);
    }

    @Override
    public NgameOrdersEntity find(Long consumerId, Long id) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        return (NgameOrdersEntity)this.selectOne("find", paramMap);
    }

    public Integer countByConsumerIdAndPrizeId(Long consumerId, Long operatingActivityId, Long prizeId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        paramMap.put("prizeId", prizeId);
        return (Integer)this.selectOne("countByConsumerIdAndPrizeId", paramMap);
    }

    @Override
    public List<NgameOrdersEntity> findByIds(Long consumerId, List<Long> ids) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("ids", ids);
        return this.selectList("findByIds", paramMap);
    }

    @Override
    public Integer findConsumerFreeNumber(Long consumerId, Long operatingActivityId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        return (Integer)this.selectOne("findConsumerFreeNumber", paramMap);
    }

    @Override
    public Integer findConsumerFreeNumberByDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        paramMap.put("start", start);
        paramMap.put("end", end);
        return (Integer)this.selectOne("findConsumerFreeNumberByDate", paramMap);
    }

    @Override
    public Integer findConsumerLimitNumber(Long consumerId, Long operatingActivityId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        return (Integer)this.selectOne("findConsumerLimitNumber", paramMap);
    }

    @Override
    public Integer findConsumerLimitNumberByDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        paramMap.put("start", start);
        paramMap.put("end", end);
        return (Integer)this.selectOne("findConsumerLimitNumberByDate", paramMap);
    }

    public Long getId() {
        NgameOrdersSequenceEntity seq = new NgameOrdersSequenceEntity();
        this.insert("getId", seq);
        return seq.getId();
    }

    @Override
    public int insert(NgameOrdersEntity ngameOrdersDto) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(ngameOrdersDto.getConsumerId());
        ngameOrdersDto.setId(this.getId());
        paramMap.put("mirror", ngameOrdersDto);
        int ret = this.insert("insert", paramMap);
        return ret;
    }

    @Override
    public int updateDeveloperBizId(Long consumerId, long id, String bizId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        paramMap.put("bizId", bizId);
        int ret = this.update("updateDeveloperBizId", paramMap);
        return ret;
    }

    @Override
    public int updateMainOrderId(Long consumerId, long id, Long mainOrderId, String mainOrderNum) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        paramMap.put("mainOrderId", mainOrderId);
        paramMap.put("mainOrderNum", mainOrderNum);
        int ret = this.update("updateMainOrderId", paramMap);
        return ret;
    }

    @Override
    public int updateStatusToConsumeSuccess(Long consumerId, Long gameOrderId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", gameOrderId);
        paramMap.put("status", 1);
        int ret = this.update("updateStatusToConsumeSuccess", paramMap);
        return ret;
    }

    @Override
    public int updateStatusToFail(Long consumerId, Long gameOrderId, String error4admin, String error4developer, String error4consumer) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", gameOrderId);
        paramMap.put("status", 3);
        paramMap.put("error4admin", TableHelper.subString(error4admin, 200));
        paramMap.put("error4developer", TableHelper.subString(error4developer, 200));
        paramMap.put("error4consumer", TableHelper.subString(error4consumer, 200));
        int ret = this.update("updateStatusToFail", paramMap);
        return ret;
    }

    @Override
    public int updateStatusToSuccess(Long consumerId, Long gameOrderId, Long gameOrderExtraId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", gameOrderId);
        paramMap.put("status", 2);
        paramMap.put("gameOrderExtraId", gameOrderExtraId);
        int ret = this.update("updateStatusToSuccess", paramMap);
        return ret;
    }

    @Override
    public int updateExchangeStatusToWaitOpen(Long consumerId, Long gameOrderId, String gameDataStr) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", gameOrderId);
        paramMap.put("status", 2);
        paramMap.put("exchangeStatus", 1);
        int ret = this.update("updateExchangeStatusToWaitOpen", paramMap);
        return ret;
    }

    @Override
    public int updateExchangeStatusToWait(Long consumerId, Long gameOrderId, String gameDataStr, Long itemId, Long appItemId, Long prizeId, String prizeType, String prizeName, String prizeFacePrice, Long couponId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", gameOrderId);
        paramMap.put("status", 2);
        paramMap.put("exchangeStatus", 2);
        paramMap.put("itemId", itemId);
        paramMap.put("appItemId", appItemId);
        paramMap.put("prizeId", prizeId);
        paramMap.put("prizeType", prizeType);
        paramMap.put("prizeName", prizeName);
        paramMap.put("prizeFacePrice", prizeFacePrice);
        paramMap.put("couponId", couponId);
        int ret = this.update("updateExchangeStatusToWait", paramMap);
        return ret;
    }

    @Override
    public int updateExchangeStatusToOverdue(Long gameOrderId, Long consumerId, String error4admin, String error4developer, String error4consumer) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", gameOrderId);
        paramMap.put("exchangeStatus", 4);
        paramMap.put("error4admin", TableHelper.subString(error4admin, 200));
        paramMap.put("error4developer", TableHelper.subString(error4developer, 200));
        paramMap.put("error4consumer", TableHelper.subString(error4consumer, 200));
        int ret = this.update("updateExchangeStatusToOverdue", paramMap);
        return ret;
    }

    @Override
    public int doTakePrize(Long consumerId, Long id) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        int ret = this.update("doTakePrize", paramMap);
        return ret;
    }

    @Override
    public int rollbackTakePrize(Long consumerId, Long id) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        int ret = this.update("rollbackTakePrize", paramMap);
        return ret;
    }

    @Override
    public int updateManualOpenPrizeExchangeStatusToWait(Long consumerId, Long gameOrderId, Long itemId, Long appItemId, Long prizeId, String prizeType, String prizeName, String prizeFacePrice, Long couponId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", gameOrderId);
        paramMap.put("exchangeStatus", 2);
        paramMap.put("itemId", itemId);
        paramMap.put("appItemId", appItemId);
        paramMap.put("prizeId", prizeId);
        paramMap.put("prizeType", prizeType);
        paramMap.put("prizeName", prizeName);
        paramMap.put("prizeFacePrice", prizeFacePrice);
        paramMap.put("couponId", couponId);
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, 7);
        Date prizeOverdueDate = cal.getTime();
        paramMap.put("prizeOverdueDate", prizeOverdueDate);
        int ret = this.update("updateManualOpenPrizeExchangeStatusToWait", paramMap);
        return ret;
    }

    @Override
    public int updateExchangeStatusToFail(Long consumerId, Long gameOrderId, String error4admin, String error4developer, String error4consumer) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", gameOrderId);
        paramMap.put("exchangeStatus", 5);
        paramMap.put("error4admin", TableHelper.subString(error4admin, 200));
        paramMap.put("error4developer", TableHelper.subString(error4developer, 200));
        paramMap.put("error4consumer", TableHelper.subString(error4consumer, 200));
        int ret = this.update("updateExchangeStatusToFail", paramMap);
        return ret;
    }

    @Override
    public int updateExchangeStatusToWaitOpenAndExtraId(Long consumerId, Long gameOrderId, String gameDataStr, Long gameOrderExtraId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", gameOrderId);
        paramMap.put("status", 2);
        paramMap.put("exchangeStatus", 1);
        paramMap.put("gameOrderExtraId", gameOrderExtraId);
        int ret = this.update("updateExchangeStatusToWaitOpenAndExtraId", paramMap);
        return ret;
    }

    @Override
    public int updateExchangeStatusToWaitOpenAndExtraIdForLuck(Long consumerId, Long gameOrderId, Long gameOrderExtraId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", gameOrderId);
        paramMap.put("status", 2);
        paramMap.put("exchangeStatus", 1);
        paramMap.put("gameOrderExtraId", gameOrderExtraId);
        int ret = this.update("updateExchangeStatusToWaitOpenAndExtraId", paramMap);
        return ret;
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.NGAME_CON;
    }
}

