/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.game.impl;

import cn.com.duiba.activity.center.api.dto.DeveloperActivityStatisticsDto;
import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerOrdersDto;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionAnswerOrdersDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionAnswerOrdersEntity;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionAnswerOrdersService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DuibaQuestionAnswerOrdersServiceImpl
implements DuibaQuestionAnswerOrdersService {
    @Resource
    private DuibaQuestionAnswerOrdersDao duibaQuestionAnswerOrdersDao;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyById(Long id) {
        return "activity-duibaQuestionAnswerOrdersById_" + id;
    }

    @Override
    public void insert(DuibaQuestionAnswerOrdersDto order) {
        DuibaQuestionAnswerOrdersEntity e = (DuibaQuestionAnswerOrdersEntity)BeanUtils.copy((Object)order, DuibaQuestionAnswerOrdersEntity.class);
        this.duibaQuestionAnswerOrdersDao.insert(e);
        order.setId(e.getId());
    }

    @Override
    public void updateStatusToConsumeSuccess(Long id) {
        this.duibaQuestionAnswerOrdersDao.updateStatusToConsumeSuccess(id);
        this.cacheClient.remove(this.getCacheKeyById(id));
    }

    @Override
    public DuibaQuestionAnswerOrdersDto find(Long id) {
        String key = this.getCacheKeyById(id);
        DuibaQuestionAnswerOrdersDto dto = (DuibaQuestionAnswerOrdersDto)this.cacheClient.get(key);
        if (dto == null) {
            dto = (DuibaQuestionAnswerOrdersDto)BeanUtils.copy((Object)this.duibaQuestionAnswerOrdersDao.find(id), DuibaQuestionAnswerOrdersDto.class);
            this.cacheClient.set(key, (Object)dto, 1, TimeUnit.HOURS);
        }
        return dto;
    }

    @Override
    public void updateStatusToConsumeFail(Long id, String error4admin, String error4developer, String error4consumer) {
        this.duibaQuestionAnswerOrdersDao.updateStatusToConsumeFail(id, error4admin, error4developer, error4consumer);
        this.cacheClient.remove(this.getCacheKeyById(id));
    }

    @Override
    public void updateStatusToSuccess(Long id) {
        this.duibaQuestionAnswerOrdersDao.updateStatusToSuccess(id);
        this.cacheClient.remove(this.getCacheKeyById(id));
    }

    @Override
    public void updateDeveloperBizId(Long questionOrderId, String bizId) {
        this.duibaQuestionAnswerOrdersDao.updateDeveloperBizId(questionOrderId, bizId);
        this.cacheClient.remove(this.getCacheKeyById(questionOrderId));
    }

    @Override
    public Integer countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        return this.duibaQuestionAnswerOrdersDao.countByConsumerIdAndOperatingActivityId(consumerId, operatingActivityId);
    }

    @Override
    public Integer countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        return this.duibaQuestionAnswerOrdersDao.countByConsumerIdAndOperatingActivityIdAndDate(consumerId, operatingActivityId, start, end);
    }

    @Override
    public Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        return this.duibaQuestionAnswerOrdersDao.countFreeByConsumerIdAndOperatingActivityId(consumerId, operatingActivityId);
    }

    @Override
    public Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        return this.duibaQuestionAnswerOrdersDao.countFreeByConsumerIdAndOperatingActivityIdAndDate(consumerId, operatingActivityId, start, end);
    }

    @Override
    public void updateExchangeStatusToFail(Long questionOrderId, String error4admin, String error4developer, String error4consumer) {
        this.duibaQuestionAnswerOrdersDao.updateExchangeStatusToFail(questionOrderId, error4admin, error4developer, error4consumer);
        this.cacheClient.remove(this.getCacheKeyById(questionOrderId));
    }

    @Override
    public void updateMainOrderId(Long questionOrderId, Long mainOrderId, String mainOrderNum) {
        this.duibaQuestionAnswerOrdersDao.updateMainOrderId(questionOrderId, mainOrderId, mainOrderNum);
        this.cacheClient.remove(this.getCacheKeyById(questionOrderId));
    }

    @Override
    public int updateExchangeStatusToOverdue(Long questionOrderId, String error4admin, String error4developer, String error4consumer) {
        int ret = this.duibaQuestionAnswerOrdersDao.updateExchangeStatusToOverdue(questionOrderId, error4admin, error4developer, error4consumer);
        this.cacheClient.remove(this.getCacheKeyById(questionOrderId));
        return ret;
    }

    @Override
    public int updateExchangeStatusToSucess(Long questionOrderId, String error4admin, String error4developer, String error4consumer) {
        int ret = this.duibaQuestionAnswerOrdersDao.updateExchangeStatusToSucess(questionOrderId, error4admin, error4developer, error4consumer);
        this.cacheClient.remove(this.getCacheKeyById(questionOrderId));
        return ret;
    }

    @Override
    public int updateExchangeStatusToWait(Long questionOrderId, String error4admin, String error4developer, String error4consumer) {
        int ret = this.duibaQuestionAnswerOrdersDao.updateExchangeStatusToWait(questionOrderId, error4admin, error4developer, error4consumer);
        this.cacheClient.remove(this.getCacheKeyById(questionOrderId));
        return ret;
    }

    @Override
    public int doTakePrize(Long questionOrderId) {
        int ret = this.duibaQuestionAnswerOrdersDao.doTakePrize(questionOrderId);
        this.cacheClient.remove(this.getCacheKeyById(questionOrderId));
        return ret;
    }

    @Override
    public void rollbackTakePrize(Long questionOrderId) {
        this.duibaQuestionAnswerOrdersDao.rollbackTakePrize(questionOrderId);
        this.cacheClient.remove(this.getCacheKeyById(questionOrderId));
    }

    @Override
    public List<Long> findOverdueOrder() {
        return this.duibaQuestionAnswerOrdersDao.findOverdueOrder();
    }

    @Override
    public List<DuibaQuestionAnswerOrdersDto> findByIds(List<Long> questionIds) {
        return BeanUtils.copyList(this.duibaQuestionAnswerOrdersDao.findByIds(questionIds), DuibaQuestionAnswerOrdersDto.class);
    }

    @Override
    public void updatePrizeInfo(DuibaQuestionAnswerOrdersDto questionOrdersDO) {
        this.duibaQuestionAnswerOrdersDao.updatePrizeInfo((DuibaQuestionAnswerOrdersEntity)BeanUtils.copy((Object)questionOrdersDO, DuibaQuestionAnswerOrdersEntity.class));
        this.cacheClient.remove(this.getCacheKeyById(questionOrdersDO.getId()));
    }

    @Override
    public void updateScore(Long orderId, Integer rightCount) {
        this.duibaQuestionAnswerOrdersDao.updateScore(orderId, rightCount);
        this.cacheClient.remove(this.getCacheKeyById(orderId));
    }

    @Override
    public DuibaQuestionAnswerOrdersDto findByAppAndDeveloperBizId(Long appId, String bizId) {
        return (DuibaQuestionAnswerOrdersDto)BeanUtils.copy((Object)this.duibaQuestionAnswerOrdersDao.findByAppAndDeveloperBizId(appId, bizId), DuibaQuestionAnswerOrdersDto.class);
    }

    @Override
    public List<DuibaQuestionAnswerOrdersDto> findQuestionOrderLimit50(Long appId, Long activityId) {
        return BeanUtils.copyList(this.duibaQuestionAnswerOrdersDao.findQuestionOrderLimit50(appId, activityId), DuibaQuestionAnswerOrdersDto.class);
    }

    @Override
    public int updateLuckPrizeNone(DuibaQuestionAnswerOrdersDto order) {
        int ret = this.duibaQuestionAnswerOrdersDao.updateLuckPrizeNone((DuibaQuestionAnswerOrdersEntity)BeanUtils.copy((Object)order, DuibaQuestionAnswerOrdersEntity.class));
        this.cacheClient.remove(this.getCacheKeyById(order.getId()));
        return ret;
    }

    @Override
    public List<DeveloperActivityStatisticsDto> countFailByOperatingActivityIds(List<Long> ids) {
        return this.duibaQuestionAnswerOrdersDao.countFailByOperatingActivityIds(ids);
    }

    @Override
    public List<DuibaQuestionAnswerOrdersDto> findByLimit(Map<String, Object> queryMap) {
        return BeanUtils.copyList(this.duibaQuestionAnswerOrdersDao.findByLimit(queryMap), DuibaQuestionAnswerOrdersDto.class);
    }

    @Override
    public Long totalCount(Map<String, Object> queryMap) {
        return this.duibaQuestionAnswerOrdersDao.totalCount(queryMap);
    }
}

