/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.hdtool.impl;

import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolOrdersDto;
import cn.com.duiba.activity.center.biz.dao.hdtool.CreditsHdtoolOrdersDao;
import cn.com.duiba.activity.center.biz.entity.hdtool.HdtoolOrdersEntity;
import cn.com.duiba.activity.center.biz.kafka.HdtoolMQSend;
import cn.com.duiba.activity.center.biz.service.hdtool.CreditsHdtoolOrdersService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CreditsHdtoolOrdersServiceImpl
implements CreditsHdtoolOrdersService {
    @Resource
    private CreditsHdtoolOrdersDao creditsHdtoolOrdersDao;
    @Autowired
    private HdtoolMQSend hdtoolMQSend;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKey(Long consumerId, Long id) {
        return "activity-creditsHdtoolOrdersById_" + consumerId + "_" + id;
    }

    @Override
    public HdtoolOrdersDto find(final Long consumerId, final Long id) {
        return (HdtoolOrdersDto)this.cacheClient.getWithCacheLoader(this.getCacheKey(consumerId, id), 2, TimeUnit.MINUTES, (CacheLoader)new CacheLoader<HdtoolOrdersDto>(){

            public HdtoolOrdersDto load() {
                return (HdtoolOrdersDto)BeanUtils.copy((Object)CreditsHdtoolOrdersServiceImpl.this.creditsHdtoolOrdersDao.find(consumerId, id), HdtoolOrdersDto.class);
            }
        });
    }

    @Override
    public Integer countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        return this.creditsHdtoolOrdersDao.countByConsumerIdAndOperatingActivityId(consumerId, operatingActivityId);
    }

    @Override
    public Integer countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        return this.creditsHdtoolOrdersDao.countByConsumerIdAndOperatingActivityIdAndDate(consumerId, operatingActivityId, start, end);
    }

    @Override
    public Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        return this.creditsHdtoolOrdersDao.countFreeByConsumerIdAndOperatingActivityId(consumerId, operatingActivityId);
    }

    @Override
    public Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        return this.creditsHdtoolOrdersDao.countFreeByConsumerIdAndOperatingActivityIdAndDate(consumerId, operatingActivityId, start, end);
    }

    @Override
    public Integer countByConsumerIdAndPrizeId(Long consumerId, Long operatingActivityId, Long prizeId) {
        return this.creditsHdtoolOrdersDao.countByConsumerIdAndPrizeId(consumerId, operatingActivityId, prizeId);
    }

    @Override
    public List<HdtoolOrdersDto> findByIds(Long consumerId, List<Long> ids) {
        return BeanUtils.copyList(this.creditsHdtoolOrdersDao.findByIds(consumerId, ids), HdtoolOrdersDto.class);
    }

    @Override
    public HdtoolOrdersDto findByAppAndDeveloperBizId(Long consumerId, Long appId, String bizId) {
        return (HdtoolOrdersDto)BeanUtils.copy((Object)this.creditsHdtoolOrdersDao.findByAppAndDeveloperBizId(consumerId, appId, bizId), HdtoolOrdersDto.class);
    }

    @Override
    public List<Long> findExpireOrder() {
        return this.creditsHdtoolOrdersDao.findExpireOrder();
    }

    @Override
    public int updateExchangeStatusToFail(Long consumerId, long id, String error4admin, String error4developer, String error4consumer) {
        int ret = this.creditsHdtoolOrdersDao.updateExchangeStatusToFail(consumerId, id, error4admin, error4developer, error4consumer);
        this.hdtoolMQSend.hdtoolSendDataSync(consumerId, id);
        this.cacheClient.remove(this.getCacheKey(consumerId, id));
        return ret;
    }

    @Override
    public int updateExchangeStatusToOverdue(Long consumerId, long id, String error4admin, String error4developer, String error4consumer) {
        int ret = this.creditsHdtoolOrdersDao.updateExchangeStatusToOverdue(consumerId, id, error4admin, error4developer, error4consumer);
        this.hdtoolMQSend.hdtoolSendDataSync(consumerId, id);
        this.cacheClient.remove(this.getCacheKey(consumerId, id));
        return ret;
    }

    @Override
    public int updateStatusToFail(Long consumerId, long id, String error4admin, String error4developer, String error4consumer) {
        int ret = this.creditsHdtoolOrdersDao.updateStatusToFail(consumerId, id, error4admin, error4developer, error4consumer);
        this.hdtoolMQSend.hdtoolSendDataSync(consumerId, id);
        this.cacheClient.remove(this.getCacheKey(consumerId, id));
        return ret;
    }

    @Override
    public Integer doTakePrize(Long consumerId, Long id) {
        int ret = this.creditsHdtoolOrdersDao.doTakePrize(consumerId, id);
        this.hdtoolMQSend.hdtoolSendDataSync(consumerId, id);
        this.cacheClient.remove(this.getCacheKey(consumerId, id));
        return ret;
    }

    @Override
    public Integer rollbackTakePrize(Long consumerId, Long id) {
        int ret = this.creditsHdtoolOrdersDao.rollbackTakePrize(consumerId, id);
        this.hdtoolMQSend.hdtoolSendDataSync(consumerId, id);
        this.cacheClient.remove(this.getCacheKey(consumerId, id));
        return ret;
    }

    @Override
    public Integer updateLotteryResult(Long consumerId, Long id, Long appItemId, Long itemId, Long prizeId, String prizeName, String prizeType, String prizeFacePrice, Long couponId) {
        int ret = this.creditsHdtoolOrdersDao.updateLotteryResult(consumerId, id, appItemId, itemId, prizeId, prizeName, prizeType, prizeFacePrice, couponId);
        this.hdtoolMQSend.hdtoolSendDataSync(consumerId, id);
        this.cacheClient.remove(this.getCacheKey(consumerId, id));
        return ret;
    }

    @Override
    public Integer updateLotteryLuckyResult(Long consumerId, Long id, Long appItemId, Long itemId, Long prizeId, String prizeName, String prizeType, String prizeFacePrice, Long couponId) {
        int ret = this.creditsHdtoolOrdersDao.updateLotteryLuckyResult(consumerId, id, appItemId, itemId, prizeId, prizeName, prizeType, prizeFacePrice, couponId);
        this.hdtoolMQSend.hdtoolSendDataSync(consumerId, id);
        this.cacheClient.remove(this.getCacheKey(consumerId, id));
        return ret;
    }

    @Override
    public int updateDeveloperBizId(Long consumerId, long id, String bizId) {
        int ret = this.creditsHdtoolOrdersDao.updateDeveloperBizId(consumerId, id, bizId);
        this.hdtoolMQSend.hdtoolSendDataSync(consumerId, id);
        this.cacheClient.remove(this.getCacheKey(consumerId, id));
        return ret;
    }

    @Override
    public int updateMainOrderId(Long consumerId, long id, Long mainOrderId, String mainOrderNum) {
        int ret = this.creditsHdtoolOrdersDao.updateMainOrderId(consumerId, id, mainOrderId, mainOrderNum);
        this.hdtoolMQSend.hdtoolSendDataSync(consumerId, id);
        this.cacheClient.remove(this.getCacheKey(consumerId, id));
        return ret;
    }

    @Override
    public void insert(HdtoolOrdersDto hdtoolOrdersDto) {
        HdtoolOrdersEntity e = (HdtoolOrdersEntity)BeanUtils.copy((Object)hdtoolOrdersDto, HdtoolOrdersEntity.class);
        this.creditsHdtoolOrdersDao.insert(e);
        hdtoolOrdersDto.setId(e.getId());
        this.hdtoolMQSend.hdtoolSendDataSync(hdtoolOrdersDto.getConsumerId(), hdtoolOrdersDto.getId());
    }
}

