/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.hdtool.impl;

import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolSkinDefaultDto;
import cn.com.duiba.activity.center.biz.dao.hdtool.HdtoolDefaultSkinDataDao;
import cn.com.duiba.activity.center.biz.entity.hdtool.HdtoolSkinDefaultEntity;
import cn.com.duiba.activity.center.biz.service.hdtool.HdtoolSkinDefaultDataSerivce;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class HdtoolSkinDefaultDataServiceImpl
implements HdtoolSkinDefaultDataSerivce {
    @Resource
    private HdtoolDefaultSkinDataDao hdtoolDefaultSkinDataDao;
    @Resource
    private CacheClient memcachedClient;

    @Override
    public void createHdtoolDefaultSkin(HdtoolSkinDefaultDto hdtoolSkinDefaultDto) {
        if (null == hdtoolSkinDefaultDto) {
            return;
        }
        HdtoolSkinDefaultEntity entity = (HdtoolSkinDefaultEntity)BeanUtils.copy((Object)hdtoolSkinDefaultDto, HdtoolSkinDefaultEntity.class);
        this.hdtoolDefaultSkinDataDao.insert(entity);
        hdtoolSkinDefaultDto.setId(entity.getId());
    }

    @Override
    public int updateHdtoolDefaultSkin(HdtoolSkinDefaultDto hdtoolSkinDefaultDto) {
        int ret = this.hdtoolDefaultSkinDataDao.updateData((HdtoolSkinDefaultEntity)BeanUtils.copy((Object)hdtoolSkinDefaultDto, HdtoolSkinDefaultEntity.class));
        if (ret == 1) {
            this.removeHdtoolSkinCache(hdtoolSkinDefaultDto.getTemplateType(), hdtoolSkinDefaultDto.getType());
        }
        return ret;
    }

    @Override
    public HdtoolSkinDefaultDto queryHdtoolBaseSkin(String templateType, String type) {
        return (HdtoolSkinDefaultDto)BeanUtils.copy((Object)this.hdtoolDefaultSkinDataDao.selectBaseHdtoolData(templateType, type), HdtoolSkinDefaultDto.class);
    }

    @Override
    public HdtoolSkinDefaultDto queryHdtoolDefaultConfig(String templateType, String type) {
        String defaultConfig = this.getHdtoolDefaultSkin(templateType, type);
        if (StringUtils.isBlank((CharSequence)defaultConfig)) {
            HdtoolSkinDefaultDto skin = (HdtoolSkinDefaultDto)BeanUtils.copy((Object)this.hdtoolDefaultSkinDataDao.selectConfigAndStyleData(templateType, type), HdtoolSkinDefaultDto.class);
            if (null != skin) {
                this.setHdtoolSkinCache(templateType, type, skin);
                return skin;
            }
        } else {
            HdtoolSkinDefaultDto skin = (HdtoolSkinDefaultDto)JSONObject.parseObject((String)defaultConfig, HdtoolSkinDefaultDto.class);
            return skin;
        }
        return null;
    }

    public void removeHdtoolSkinCache(String templateType, String type) {
        this.memcachedClient.remove(this.getSkinCacheKey(templateType, type));
    }

    public void setHdtoolSkinCache(String templateType, String type, HdtoolSkinDefaultDto defaultSkin) {
        String json = JSONObject.toJSONString((Object)defaultSkin);
        this.memcachedClient.set(this.getSkinCacheKey(templateType, type), (Object)json, 3600);
    }

    public String getHdtoolDefaultSkin(String templateType, String type) {
        return (String)this.memcachedClient.get(this.getSkinCacheKey(templateType, type));
    }

    public String getSkinCacheKey(String templateType, String type) {
        return "activity-keyHdtoolDefaultSkinCacheKeyId_" + templateType + "_" + type;
    }

    @Override
    public List<HdtoolSkinDefaultDto> queryListPagnation(Integer offset, Integer max) {
        return BeanUtils.copyList(this.hdtoolDefaultSkinDataDao.selectAllByPagination(offset, max), HdtoolSkinDefaultDto.class);
    }

    @Override
    public Integer queryListCount() {
        return this.hdtoolDefaultSkinDataDao.selectAllByPaginationCount();
    }
}

