/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.singlelottery.impl;

import cn.com.duiba.activity.center.api.dto.singlelottery.AppSingleLotteryDto;
import cn.com.duiba.activity.center.biz.dao.singlelottery.SingleLotteryDao;
import cn.com.duiba.activity.center.biz.entity.singlelottery.AppSingleLotteryEntity;
import cn.com.duiba.activity.center.biz.service.singlelottery.SingleLotteryService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SingleLotteryServiceImpl
implements SingleLotteryService {
    @Resource
    private SingleLotteryDao singleLotteryDao;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyById(Long id) {
        return "activity-keySingleLotteryById_" + id;
    }

    @Override
    public AppSingleLotteryDto find(Long id) {
        String key = this.getCacheKeyById(id);
        AppSingleLotteryDto d = (AppSingleLotteryDto)this.cacheClient.get(key);
        if (d == null) {
            AppSingleLotteryEntity entity = this.singleLotteryDao.find(id);
            if (entity == null) {
                return null;
            }
            d = (AppSingleLotteryDto)BeanUtils.copy((Object)((Object)entity), AppSingleLotteryDto.class);
            this.cacheClient.set(key, (Object)d, 300);
        }
        return (AppSingleLotteryDto)BeanUtils.copy((Object)((Object)this.singleLotteryDao.find(id)), AppSingleLotteryDto.class);
    }

    @Override
    @Transactional(value="credits")
    public AppSingleLotteryDto findForupdate(Long id) {
        return (AppSingleLotteryDto)BeanUtils.copy((Object)((Object)this.singleLotteryDao.findForupdate(id)), AppSingleLotteryDto.class);
    }

    @Override
    public List<AppSingleLotteryDto> findAllByIds(List<Long> ids) {
        return BeanUtils.copyList(this.singleLotteryDao.findAllByIds(ids), AppSingleLotteryDto.class);
    }

    @Override
    public int addMainAppItemRemainingById(Long id, Integer addMainAppItemRemaining) {
        int result = this.singleLotteryDao.addMainAppItemRemainingById(id, addMainAppItemRemaining);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return result;
    }

    @Override
    public int subMainAppItemRemainingById(Long id, Integer subMainAppItemRemaining) {
        int result = this.singleLotteryDao.subMainAppItemRemainingById(id, subMainAppItemRemaining);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return result;
    }

    @Override
    @Transactional(value="credits")
    public Integer findRemaingForupdate(Long id) {
        return this.singleLotteryDao.findRemaingForupdate(id);
    }

    @Override
    public void insert(AppSingleLotteryDto appSingleLotteryDto) {
        AppSingleLotteryEntity entity = new AppSingleLotteryEntity(true);
        BeanUtils.copy((Object)appSingleLotteryDto, (Object)((Object)entity));
        this.singleLotteryDao.insert(entity);
        appSingleLotteryDto.setId(entity.getId());
    }

    @Override
    public int update(AppSingleLotteryDto appSingleLotteryDto) {
        int result = this.singleLotteryDao.update((AppSingleLotteryEntity)((Object)BeanUtils.copy((Object)appSingleLotteryDto, AppSingleLotteryEntity.class)));
        this.cacheClient.remove(this.getCacheKeyById(appSingleLotteryDto.getId()));
        return result;
    }

    @Override
    public int reduceMainAppItemRemaining(Long id) {
        int result = this.singleLotteryDao.reduceMainAppItemRemaining(id);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return result;
    }

    @Override
    public int addMainAppItemRemaining(Long id) {
        int result = this.singleLotteryDao.addMainAppItemRemaining(id);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return result;
    }

    @Override
    public int updateForDevEdit(AppSingleLotteryDto appSingleLottery) {
        int result = this.singleLotteryDao.updateForDevEdit((AppSingleLotteryEntity)((Object)BeanUtils.copy((Object)appSingleLottery, AppSingleLotteryEntity.class)));
        this.cacheClient.remove(this.getCacheKeyById(appSingleLottery.getId()));
        return result;
    }
}

