/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.game.impl;

import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerOrdersExtraDto;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionAnswerOrdersExtraDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionAnswerOrdersExtraEntity;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionAnswerOrdersExtraService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DuibaQuestionAnswerOrdersExtraServiceImpl
implements DuibaQuestionAnswerOrdersExtraService {
    @Resource
    private DuibaQuestionAnswerOrdersExtraDao duibaQuestionAnswerOrdersExtraDao;
    @Resource
    private CacheClient cacheClient;

    @Override
    public int insert(DuibaQuestionAnswerOrdersExtraDto duibaQuestionAnswerOrdersExtraDO) {
        DuibaQuestionAnswerOrdersExtraEntity e = (DuibaQuestionAnswerOrdersExtraEntity)BeanUtils.copy((Object)duibaQuestionAnswerOrdersExtraDO, DuibaQuestionAnswerOrdersExtraEntity.class);
        int ret = this.duibaQuestionAnswerOrdersExtraDao.insert(e);
        duibaQuestionAnswerOrdersExtraDO.setId(e.getId());
        this.cacheClient.remove(this.getCacheKeyByOrderId(e.getQuestionOrdersId()));
        return ret;
    }

    @Override
    public DuibaQuestionAnswerOrdersExtraDto find(Long ordersExtraId) {
        return (DuibaQuestionAnswerOrdersExtraDto)BeanUtils.copy((Object)this.duibaQuestionAnswerOrdersExtraDao.find(ordersExtraId), DuibaQuestionAnswerOrdersExtraDto.class);
    }

    @Override
    public int update(Long ordersExtraId, String answerData, Integer rightCount) {
        DuibaQuestionAnswerOrdersExtraEntity e = this.duibaQuestionAnswerOrdersExtraDao.find(ordersExtraId);
        int ret = this.duibaQuestionAnswerOrdersExtraDao.update(ordersExtraId, answerData, rightCount);
        this.cacheClient.remove(this.getCacheKeyByOrderId(e.getQuestionOrdersId()));
        return ret;
    }

    private String getCacheKeyByOrderId(Long questionOrderId) {
        return "activity-duibaQuestionAnswerOrdersExtraByOrderId_" + questionOrderId;
    }

    @Override
    public DuibaQuestionAnswerOrdersExtraDto findByQuestionOrderId(Long questionOrderId) {
        String key = this.getCacheKeyByOrderId(questionOrderId);
        DuibaQuestionAnswerOrdersExtraDto dto = (DuibaQuestionAnswerOrdersExtraDto)this.cacheClient.get(key);
        if (dto == null) {
            dto = (DuibaQuestionAnswerOrdersExtraDto)BeanUtils.copy((Object)this.duibaQuestionAnswerOrdersExtraDao.findByQuestionOrderId(questionOrderId), DuibaQuestionAnswerOrdersExtraDto.class);
            this.cacheClient.set(key, (Object)dto, 1, TimeUnit.HOURS);
        }
        return dto;
    }
}

