/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.hdtool.impl;

import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolOptionsDto;
import cn.com.duiba.activity.center.biz.dao.hdtool.DuibaHdtoolOptionsDao;
import cn.com.duiba.activity.center.biz.entity.hdtool.DuibaHdtoolOptionsEntity;
import cn.com.duiba.activity.center.biz.service.hdtool.DuibaHdtoolOptionsService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DuibaHdtoolOptionsServiceImpl
implements DuibaHdtoolOptionsService {
    @Resource
    private DuibaHdtoolOptionsDao duibaHdtoolOptionsDao;
    @Resource
    private CacheClient cacheClient;

    private String getDuibaHdtoolOptionsCacheKeyById(Long id) {
        return "activity-duibaHdtoolOptionsById_" + id;
    }

    private String getDuibaHdtoolOptionsCacheKeyByHdtoolId(Long hdtoolId) {
        return "activity-duibaHdtoolOptionsByHdtoolId_" + hdtoolId;
    }

    @Override
    public List<DuibaHdtoolOptionsDto> findByHdtoolId(Long hdtoolId) {
        return BeanUtils.copyList(this.duibaHdtoolOptionsDao.findByHdtoolId(hdtoolId), DuibaHdtoolOptionsDto.class);
    }

    @Override
    public int addRemainingById(Long id, Integer addRemaining) {
        int ret = this.duibaHdtoolOptionsDao.addRemainingById(id, addRemaining);
        this.removeDuibaHdtoolOptionsCacheById(id);
        return ret;
    }

    @Override
    public int subRemainingById(Long id, Integer subRemaining) {
        int ret = this.duibaHdtoolOptionsDao.subRemainingById(id, subRemaining);
        this.removeDuibaHdtoolOptionsCacheById(id);
        return ret;
    }

    @Override
    public int updateRemainingById(Long id, Integer remaining) {
        int ret = this.duibaHdtoolOptionsDao.updateRemainingById(id, remaining);
        this.removeDuibaHdtoolOptionsCacheById(id);
        return ret;
    }

    @Override
    @Transactional(value="credits")
    public Integer findRemaingForupdate(Long id) {
        return this.duibaHdtoolOptionsDao.findRemaingForupdate(id);
    }

    @Override
    public List<DuibaHdtoolOptionsDto> findOptionsByDuibaHdtoolId(final Long hdtoolId) {
        return (List)this.cacheClient.getWithCacheLoader(this.getDuibaHdtoolOptionsCacheKeyByHdtoolId(hdtoolId), 30, TimeUnit.MINUTES, (CacheLoader)new CacheLoader<List<DuibaHdtoolOptionsDto>>(){

            public List<DuibaHdtoolOptionsDto> load() {
                return BeanUtils.copyList(DuibaHdtoolOptionsServiceImpl.this.duibaHdtoolOptionsDao.findOptionsByDuibaHdtoolId(hdtoolId), DuibaHdtoolOptionsDto.class);
            }
        });
    }

    @Override
    public Map<Long, List<DuibaHdtoolOptionsDto>> findOptionsByDuibaHdtoolIds(List<Long> hdtoolIds) {
        List<DuibaHdtoolOptionsEntity> list = this.duibaHdtoolOptionsDao.findOptionsByDuibaHdtoolIds(hdtoolIds);
        HashMap<Long, List<DuibaHdtoolOptionsDto>> map = new HashMap<Long, List<DuibaHdtoolOptionsDto>>();
        for (DuibaHdtoolOptionsEntity e : list) {
            ArrayList<Object> innerList = (ArrayList<Object>)map.get(e.getDuibaHdtoolId());
            if (innerList == null) {
                innerList = new ArrayList<Object>();
                map.put(e.getDuibaHdtoolId(), innerList);
            }
            innerList.add(BeanUtils.copy((Object)e, DuibaHdtoolOptionsDto.class));
        }
        return map;
    }

    @Override
    public Integer countOptionsByHdtoolId(Long hdtoolId) {
        return this.duibaHdtoolOptionsDao.countOptionsByHdtoolId(hdtoolId);
    }

    @Override
    public DuibaHdtoolOptionsDto findOptionById(final Long id) {
        return (DuibaHdtoolOptionsDto)this.cacheClient.getWithCacheLoader(this.getDuibaHdtoolOptionsCacheKeyById(id), 30, TimeUnit.SECONDS, (CacheLoader)new CacheLoader<DuibaHdtoolOptionsDto>(){

            public DuibaHdtoolOptionsDto load() {
                return (DuibaHdtoolOptionsDto)BeanUtils.copy((Object)DuibaHdtoolOptionsServiceImpl.this.duibaHdtoolOptionsDao.findOptionById(id), DuibaHdtoolOptionsDto.class);
            }
        });
    }

    @Override
    @Transactional(value="credits")
    public DuibaHdtoolOptionsDto findOptionByIdForupdate(Long id) {
        return (DuibaHdtoolOptionsDto)BeanUtils.copy((Object)this.duibaHdtoolOptionsDao.findOptionByIdForupdate(id), DuibaHdtoolOptionsDto.class);
    }

    @Override
    public List<Long> findHasUserdHdIds(Long itemId) {
        return this.duibaHdtoolOptionsDao.findHasUserdHdIds(itemId);
    }

    @Override
    public int decrementOptionRemaining(Long id) {
        int ret = this.duibaHdtoolOptionsDao.decrementOptionRemaining(id);
        this.removeDuibaHdtoolOptionsCacheById(id);
        return ret;
    }

    @Override
    public int incrementOptionRemaining(Long id) {
        int ret = this.duibaHdtoolOptionsDao.incrementOptionRemaining(id);
        this.removeDuibaHdtoolOptionsCacheById(id);
        return ret;
    }

    @Override
    public int deleteOptions(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return 0;
        }
        int ret = this.duibaHdtoolOptionsDao.deleteOptions(ids);
        for (Long id : ids) {
            this.removeDuibaHdtoolOptionsCacheById(id);
        }
        return ret;
    }

    @Override
    public int updateHdtoolPrize(DuibaHdtoolOptionsDto duibaHdToolOptionDO) {
        int ret = this.duibaHdtoolOptionsDao.updateHdtoolPrize((DuibaHdtoolOptionsEntity)BeanUtils.copy((Object)duibaHdToolOptionDO, DuibaHdtoolOptionsEntity.class));
        this.removeDuibaHdtoolOptionsCacheById(duibaHdToolOptionDO.getId());
        return ret;
    }

    @Override
    public void insertHdtoolOption(DuibaHdtoolOptionsDto duibaHdToolOptionDO) {
        DuibaHdtoolOptionsEntity e = (DuibaHdtoolOptionsEntity)BeanUtils.copy((Object)duibaHdToolOptionDO, DuibaHdtoolOptionsEntity.class);
        this.duibaHdtoolOptionsDao.insertHdtoolOption(e);
        this.cacheClient.remove(this.getDuibaHdtoolOptionsCacheKeyByHdtoolId(e.getDuibaHdtoolId()));
        duibaHdToolOptionDO.setId(e.getId());
    }

    @Override
    public int updateHdtoolOption(DuibaHdtoolOptionsDto duibaHdToolOptionDO) {
        int ret = this.duibaHdtoolOptionsDao.updateHdtoolOption((DuibaHdtoolOptionsEntity)BeanUtils.copy((Object)duibaHdToolOptionDO, DuibaHdtoolOptionsEntity.class));
        this.removeDuibaHdtoolOptionsCacheById(duibaHdToolOptionDO.getId());
        return ret;
    }

    private void removeDuibaHdtoolOptionsCacheById(Long optionsId) {
        this.cacheClient.remove(this.getDuibaHdtoolOptionsCacheKeyById(optionsId));
        DuibaHdtoolOptionsDto dto = this.findOptionById(optionsId);
        if (dto != null) {
            this.cacheClient.remove(this.getDuibaHdtoolOptionsCacheKeyByHdtoolId(dto.getDuibaHdtoolId()));
        }
    }
}

