/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.quizz.impl;

import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzOptionsDto;
import cn.com.duiba.activity.center.biz.dao.quizz.DuibaQuizzOptionsDao;
import cn.com.duiba.activity.center.biz.entity.quizz.DuibaQuizzOptionsEntity;
import cn.com.duiba.activity.center.biz.service.quizz.DuibaQuizzOptionsService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DuibaQuizzOptionsServiceImpl
implements DuibaQuizzOptionsService {
    @Resource
    private DuibaQuizzOptionsDao duibaQuizzOptionsDao;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyById(Long id) {
        return "activity-duibaQuizzOptionsById_" + id;
    }

    private String getCacheKeyByQuizzId(Long quizzId) {
        return "activity-duibaQuizzOptionsByQuizzId_" + quizzId;
    }

    @Override
    public List<DuibaQuizzOptionsDto> findOptionsByQuizzId(final Long duibaQuizzId) {
        if (duibaQuizzId == null) {
            return Collections.emptyList();
        }
        return (List)this.cacheClient.getWithCacheLoader(this.getCacheKeyByQuizzId(duibaQuizzId), 1, TimeUnit.HOURS, (CacheLoader)new CacheLoader<List<DuibaQuizzOptionsDto>>(){

            public List<DuibaQuizzOptionsDto> load() {
                List<DuibaQuizzOptionsEntity> entities = DuibaQuizzOptionsServiceImpl.this.duibaQuizzOptionsDao.findOptionsByQuizzId(duibaQuizzId);
                return BeanUtils.copyList(entities, DuibaQuizzOptionsDto.class);
            }
        });
    }

    @Override
    public DuibaQuizzOptionsDto find(final Long id) {
        if (id == null) {
            return null;
        }
        return (DuibaQuizzOptionsDto)this.cacheClient.getWithCacheLoader(this.getCacheKeyById(id), 1, TimeUnit.HOURS, (CacheLoader)new CacheLoader<DuibaQuizzOptionsDto>(){

            public DuibaQuizzOptionsDto load() {
                DuibaQuizzOptionsEntity entity = DuibaQuizzOptionsServiceImpl.this.duibaQuizzOptionsDao.find(id);
                return (DuibaQuizzOptionsDto)BeanUtils.copy((Object)((Object)entity), DuibaQuizzOptionsDto.class);
            }
        });
    }

    @Override
    public Map<Long, List<DuibaQuizzOptionsDto>> findByQuizzIds(List<Long> quizzIds) {
        List<DuibaQuizzOptionsEntity> list = this.duibaQuizzOptionsDao.findOptionsByQuizzIds(quizzIds);
        HashMap<Long, List<DuibaQuizzOptionsDto>> map = new HashMap<Long, List<DuibaQuizzOptionsDto>>();
        for (DuibaQuizzOptionsEntity e : list) {
            ArrayList<Object> innerList = (ArrayList<Object>)map.get(e.getDuibaQuizzId());
            if (innerList == null) {
                innerList = new ArrayList<Object>();
                map.put(e.getDuibaQuizzId(), innerList);
            }
            innerList.add(BeanUtils.copy((Object)((Object)e), DuibaQuizzOptionsDto.class));
        }
        return map;
    }

    @Override
    public int delete(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return 0;
        }
        HashSet<Long> quizzIds = new HashSet<Long>();
        for (Long id : ids) {
            DuibaQuizzOptionsDto dto = this.find(id);
            if (dto == null) continue;
            quizzIds.add(dto.getDuibaQuizzId());
        }
        int ret = this.duibaQuizzOptionsDao.delete(ids);
        for (Long id : ids) {
            this.cacheClient.remove(this.getCacheKeyById(id));
        }
        for (Long quizzId : quizzIds) {
            this.cacheClient.remove(this.getCacheKeyByQuizzId(quizzId));
        }
        return ret;
    }

    @Override
    public void insert(DuibaQuizzOptionsDto duibaQuizzOptionsDto) {
        DuibaQuizzOptionsEntity entity = (DuibaQuizzOptionsEntity)((Object)BeanUtils.copy((Object)duibaQuizzOptionsDto, DuibaQuizzOptionsEntity.class));
        this.duibaQuizzOptionsDao.insert(entity);
        duibaQuizzOptionsDto.setId(entity.getId());
        this.cacheClient.remove(this.getCacheKeyByQuizzId(duibaQuizzOptionsDto.getDuibaQuizzId()));
    }

    @Override
    public int updateInfoForm(DuibaQuizzOptionsDto quizzOptionsDO) {
        int ret = this.duibaQuizzOptionsDao.updateInfoForm((DuibaQuizzOptionsEntity)((Object)BeanUtils.copy((Object)quizzOptionsDO, DuibaQuizzOptionsEntity.class)));
        this.cacheClient.remove(this.getCacheKeyById(quizzOptionsDO.getId()));
        quizzOptionsDO = this.find(quizzOptionsDO.getId());
        this.cacheClient.remove(this.getCacheKeyByQuizzId(quizzOptionsDO.getDuibaQuizzId()));
        return ret;
    }

    @Override
    public int updateRemainingById(Long id, Integer remaining) {
        int ret = this.duibaQuizzOptionsDao.updateRemainingById(id, remaining);
        this.cacheClient.remove(this.getCacheKeyById(id));
        DuibaQuizzOptionsDto dto = this.find(id);
        this.cacheClient.remove(this.getCacheKeyByQuizzId(dto.getDuibaQuizzId()));
        return ret;
    }
}

