package cn.com.duiba.activity.center.biz.dao.chaos.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.chaos.RetryOrdersFasterDao;
import cn.com.duiba.activity.center.biz.entity.chaos.RetryOrdersFasterEntity;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/6/22.
 */
@Repository
public class RetryOrdersFasterDaoImpl extends ActivityBaseDao implements RetryOrdersFasterDao{
    @Override
    public void insert(RetryOrdersFasterEntity RetryOrdersFasterEntity) {
        insert("insert",RetryOrdersFasterEntity);
    }

    @Override
    public void deleteByOrderId(Long orderId) {
        Map<String,Object> param = new HashMap<String,Object>();
        param.put("orderId", orderId);
        delete("deleteByOrderId", param);
    }

    @Override
    public RetryOrdersFasterEntity findByOrderId(Long orderId) {
        Map<String,Object> param = new HashMap<String,Object>();
        param.put("orderId", orderId);
        return selectOne("findByOrderId", param);
    }

    @Override
    public List<RetryOrdersFasterEntity> findEndtimeRetryOrder() {
        return selectList("findEndtimeRetryOrder");
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS_ACTIVITY;
    }
}
