package cn.com.duiba.activity.center.biz.dao.game.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionAnswerOrdersExtraDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionAnswerOrdersExtraEntity;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.Map;

@Repository
public class DuibaQuestionAnswerOrdersExtraDaoImpl extends ActivityBaseDao implements DuibaQuestionAnswerOrdersExtraDao {

    @Override
    public int insert(DuibaQuestionAnswerOrdersExtraEntity duibaQuestionAnswerOrdersExtraDO) {
        return insert("insert", duibaQuestionAnswerOrdersExtraDO);
    }

    @Override
    public DuibaQuestionAnswerOrdersExtraEntity find(Long ordersExtraId) {
        Map<String, Object> parames = new HashMap<String, Object>();
        parames.put("id", ordersExtraId);
        return selectOne("find", parames);
    }

    @Override
    public int update(Long ordersExtraId, String answerData, Integer rightCount) {
        Map<String, Object> parames = new HashMap<String, Object>();
        parames.put("id", ordersExtraId);
        parames.put("answerData", answerData);
        parames.put("rightCount", rightCount);
       return update("update", parames);
    }

    public DuibaQuestionAnswerOrdersExtraEntity findByQuestionOrderId(Long questionOrderId) {
        Map<String, Object> parames = new HashMap<String, Object>();
        parames.put("questionOrderId", questionOrderId);
        return selectOne("findByQuestionOrderId", parames);
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS_GAME;
    }
}
