package cn.com.duiba.activity.center.biz.dao.game.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionStockDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionStockEntity;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository
public class DuibaQuestionStockDaoImpl extends ActivityBaseDao implements DuibaQuestionStockDao {

	@Override
	public int subStock(Long id, Integer subNumber) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("subNumber", subNumber);
		return update("subStock", paramMap);
	}

	@Override
	public int addStock(Long id, Integer addNumber) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("addNumber", addNumber);
		return update("addStock", paramMap);
	}

	@Override
	public DuibaQuestionStockEntity findRemaining(Long questionOptionId, String relationType) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("questionOptionId", questionOptionId);
		paramMap.put("relationType", relationType);
		return selectOne("findRemaining", paramMap);
	}


	@Override
	public DuibaQuestionStockEntity findByQuestionOptionId(Long questionOptionId) {
		return selectOne("findByQuestionOptionId", questionOptionId);
	}

	@Override
	public List<DuibaQuestionStockEntity> findByQuestionOptionIds(List<Long> list) {
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("list", list);
		return selectList("findByQuestionOptionIds", params);
	}

	@Override
	public int updateStockAdd(Long id, Integer stockAdd, String type) {
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("id", id);
		params.put("stockAdd", stockAdd);
		params.put("type", type);
		return update("updateStockAdd", params);
	}

	@Override
	public int updateStockSub(Long id, Integer stockSub, String type) {
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("id", id);
		params.put("stockSub", stockSub);
		params.put("type", type);
		return update("updateStockSub", params);
	}

	@Override
	public void add(DuibaQuestionStockEntity questionStockDO) {
		insert("add", questionStockDO);
	}

	@Override
	public void addBatch(List<DuibaQuestionStockEntity> list) {
		Map<String, Object> params = Maps.newHashMap();
		params.put("list", list);
		insert("addBatch", params);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.CREDITS_GAME;
	}
}
