package cn.com.duiba.activity.center.biz.dao.hdtool;

import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolAppSpecifyDto;
import cn.com.duiba.activity.center.biz.entity.ActivityExtraInfoEntity;
import cn.com.duiba.activity.center.biz.entity.AddActivityEntity;
import cn.com.duiba.activity.center.biz.entity.hdtool.DuibaHdtoolEntity;
import cn.com.duiba.activity.center.biz.entity.hdtool.DuibaHdtoolOptionsEntity;
import cn.com.duiba.activity.center.biz.entity.hdtool.HdtoolAppSpecifyEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 兑吧活动工具业务DAO
 */
public interface DuibaHdtoolDao {
	
	/**
	 * 查询一天内，需要定时下架的转盘抽奖
	 * @return
	 */
	public List<DuibaHdtoolEntity> findAutoOff();

	/**
	 * 根据ID查询
	 */
	public DuibaHdtoolEntity find(Long id);

	/**
	 * 活动工具分页列表
	 */
	//Start chaijiangang,管理员后台活动管理页面增加筛选条件,2016/03/30
	public List<DuibaHdtoolEntity> findDuibaHdToolsList(Map<String, Object> paramMap);

	/**
	 * 统计活动工具条数
	 */
	public Integer countDuibaHdToolsList(Map<String, Object> queryMap);

	/**
	 * 根据APP查询活动工具
	 */
	public List<AddActivityEntity> findAllDuibaHdTools(Long appId);

	/**
	 * 根据ID集合查询活动工具
	 */
	public List<DuibaHdtoolEntity> findAllByIds(List<Long> ids);

	/**
	 * 根据活动ID查询奖项
	 */
	public List<DuibaHdtoolOptionsEntity> findOptionsByDuibaHdtoolId(Long hdtoolId);

	/**
	 * 根据活动ID查询奖项
	 */
	public List<DuibaHdtoolOptionsEntity> findOptionsByDuibaHdtoolIds(List<Long> hdtoolIds);

	/**
	 * 查询活动奖项个数
	 */
	public Integer countOptionsByHdtoolId(Long hdtoolId);

	/**
	 * 根据ID查询
	 */
	public DuibaHdtoolOptionsEntity findOptionById(Long id);
	
	public DuibaHdtoolOptionsEntity findOptionByIdForupdate(Long id);
	
	/**
	 * 根据活动ID查询定向
	 */
	public List<HdtoolAppSpecifyEntity> findAllSpecifyByHdToolId(Long hdToolId);

	/**
	 * 根据活动ID或APP查询定向关系
	 */
	public HdtoolAppSpecifyEntity findSpecifyByHdToolIdAndApp(Long duibaHdToolId, Long appId);

	public List<HdtoolAppSpecifyEntity> findSpecifyByHdToolIdsAndApp(List<Long> duibaHdToolIds, Long appId);

	/**
	 * 根据ID查询定向关系
	 */
	public HdtoolAppSpecifyEntity findSpecifyById(Long id);
	
	/**
	 * 根据ID查询额外信息
	 */
	public ActivityExtraInfoEntity findExtraInfoById(Long id);


	/**
	 * 查询item是否被活动工具使用
	 *
	 * @param itemId
	 * @return
	 */
	public List<Long> findHasUserdHdIds(Long itemId);

	/**
	 * @param queryMap
	 * @return
	 */
	public Long getCountDuibaHdTool(Map<String, Object> queryMap);

	/**
	 * @param queryMap
	 * @return
	 */
	public List<DuibaHdtoolEntity> findDuibaToolList(Map<String, Object> queryMap);

	//from DuibaHdtoolTextChangeDao


	public int updateAutoOffDateNull(Long id);

	/**
	 * 新增兑吧活动工具
	 */
	public void insert(DuibaHdtoolEntity duibaHdtoolDto);

	/**
	 * 删除兑吧活动
	 */
	public int deleteById(Long id);

	/**
	 * 修改兑吧活动工具
	 */
	public int update(DuibaHdtoolEntity duibaHdtoolDto);

	/**
	 * 修改活动工具状态
	 */
	public int updateStatus(Long id, Integer status);

	/**
	 * 减奖品数量
	 */
	public int decrementOptionRemaining(@Param("id") Long id);

	/**
	 * 加奖品数量
	 */
	public int incrementOptionRemaining(@Param("id") Long id);

	/**
	 * 删除奖项
	 */
	public int deleteOptions(List<Long> ids);

	/**
	 * 修改奖项
	 */
	public int updateHdtoolPrize(DuibaHdtoolOptionsEntity duibaHdToolOptionDO);

	/**
	 * 新增兑换活动工具奖项
	 */
	public void insertHdtoolOption(DuibaHdtoolOptionsEntity duibaHdToolOptionDO);

	/**
	 * 修改兑吧活动工具
	 */
	public int updateHdtoolOption(DuibaHdtoolOptionsEntity duibaHdToolOptionDO);

	/**
	 * 删除定向关系
	 */
	public int deleteSpecifyById(Long id);

	/**
	 * 添加定向关系
	 */
	public void insertSpecify(HdtoolAppSpecifyEntity hdtoolAppSpecifyDO);

	public int updateActivityCategory(long  duibaHdtoolId,long activityCategoryId);
	
	/**
     * 根据ID查询标签
     */
    public String findTag(Long id);
}
