package cn.com.duiba.activity.center.biz.dao.ngame;


import cn.com.duiba.activity.center.biz.entity.ngame.NgameConsumerRecordEntity;

import java.util.List;
import java.util.Map;

public interface NgameConsumerRecordDao {

	public NgameConsumerRecordEntity findRecordByConIdAndNgameId(Long consumerId, Long duibaNgameId);

	public List<NgameConsumerRecordEntity> findGameConfigDuibaScoreByDesc(Long duibaNgameId, Integer number);
	public List<NgameConsumerRecordEntity> findGameConfigDuibaScoreByAsc(Long duibaNgameId, Integer number);
	
	public List<NgameConsumerRecordEntity> findConsumerGameConfigDuibaScoreByDesc(Long duibaNgameId, Integer number);
	public List<NgameConsumerRecordEntity> findConsumerGameConfigDuibaScoreByAsc(Long duibaNgameId, Integer number);

	public void insert(NgameConsumerRecordEntity gameConsumerRecordDO);

	public Integer updateScore(Long id, Long score, String autoOpenPrizeId, Long gameOrderId);

	public Integer updateScoreAndTotalScore(Long id, Long score, Integer shareScore, String autoOpenPrizeId, Long gameOrderId);

	public Integer updateTotalScore(Long id, Integer shareScore);

	public Integer updateIsGivePrize(Long id, Boolean isGivePrize);

	public Integer updateAutoOpenPrizeId(Long id, String autoOpenPrizeId);

	public void markCheat(Long id, Boolean cheat);
	
	public List<NgameConsumerRecordEntity> findByConsumerAndIds(Long consumerId, List<Long> ids);

	List<NgameConsumerRecordEntity> findTopWinning(Map<String, Object> params);

	List<NgameConsumerRecordEntity> findTopWinningAsc(Map<String, Object> params);

	Integer countCheatBefore(Integer limit,Long gameConfigDuibaId);

	Integer countTopWinning(Map<String, Object> params);

	NgameConsumerRecordEntity find(Long id);

	void setCheatReason(Long id, String cheatReason);

	public List<NgameConsumerRecordEntity> findShareConsumerByGameConfigDuibaId(Long duibaNgameId);
	public int updateByGameConfigShare(Long id, Long duibaNgameId, Long shareScore);
	NgameConsumerRecordEntity findByConsumerIdAndGameConfigDuibaId(Long consumerId, Long gameConfigDuibaId);
	void updateScore(Long id, Long score);
}
