package cn.com.duiba.activity.center.biz.dao.ngame.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.ngame.DuibaNgameStockConsumeDao;
import cn.com.duiba.activity.center.biz.entity.ngame.DuibaNgameStockConsumeEntity;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.Map;

@Repository
public class DuibaNgameStockConsumeDaoImpl extends ActivityBaseDao implements DuibaNgameStockConsumeDao {

	@Override
	public DuibaNgameStockConsumeEntity findByBizId(Long stockId, String bizId, String action) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("bizId", bizId);
		paramMap.put("action", action);
		paramMap.put("stockId", stockId);
		return selectOne("findByBizId", paramMap);
	}

	@Override
	public void insert(DuibaNgameStockConsumeEntity gameStockConsumeDO) {
		insert("insert", gameStockConsumeDO);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.NGAME;
	}
}
