package cn.com.duiba.activity.center.biz.dao.ngame.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.ngame.NgameStockDao;
import cn.com.duiba.activity.center.biz.entity.ngame.NgameStockEntity;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository
public class NgameStockDaoImpl extends ActivityBaseDao implements NgameStockDao {

	@Override
	public NgameStockEntity findRemaining(Long relationId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("relationId", relationId);
		return selectOne("findRemaining", paramMap);
	}

	@Override
	public int subStock(Long id, Integer subNumber) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("subNumber", subNumber);
		return update("subStock", paramMap);
	}

	@Override
	public int addStock(Long id, Integer addNumber) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("addNumber", addNumber);
		return update("addStock", paramMap);
	}

	@Override
	public NgameStockEntity findByGameOptionId(Long gameOptionId) {
		Map<String, Object> params = Maps.newHashMap();
		params.put("gameOptionId", gameOptionId);
		return selectOne("findByGameOptionId", params);
	}

	@Override
	public List<NgameStockEntity> findByGameOptionIds(List<Long> list) {
		Map<String, Object> params = Maps.newHashMap();
		params.put("list", list);
		return selectList("findByGameOptionIds", params);
	}

	@Override
	public void updateStock(NgameStockEntity ngameStockDto) {
		update("updateStock", ngameStockDto);
	}

	@Override
	public void add(NgameStockEntity ngameStockDto) {
		insert("add", ngameStockDto);
	}

	@Override
	public void addBatch(List<NgameStockEntity> list) {
		Map<String, Object> params = Maps.newHashMap();
		params.put("list", list);
		insert("addBatch", params);
	}


	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.NGAME;
	}
}
