package cn.com.duiba.activity.center.biz.dao.ngame_con.impl;

import cn.com.duiba.activity.center.api.dto.ngame.NgameOrdersDto;
import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.ngame_con.NgameOrdersConsumerDao;
import cn.com.duiba.activity.center.biz.entity.ngame.NgameOrdersEntity;
import cn.com.duiba.activity.center.biz.entity.ngame.NgameOrdersSequenceEntity;
import org.springframework.stereotype.Repository;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

import static cn.com.duiba.activity.center.biz.support.TableHelper.getTbSuffixParamsMap;
import static cn.com.duiba.activity.center.biz.support.TableHelper.subString;

@Repository
public class NgameOrdersConsumerDaoImpl extends ActivityBaseDao implements NgameOrdersConsumerDao {

	/**
     * 查询用户参与活动次数
     */
    public Integer countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
    	Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        return selectOne("countByConsumerIdAndOperatingActivityId", paramMap);
    }

    /**
     * 查询用户在时间段内参与活动次数
     */
    public Integer countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
    	Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        paramMap.put("start", start);
        paramMap.put("end", end);
        return selectOne("countByConsumerIdAndOperatingActivityIdAndDate", paramMap);
    }

    /**
     * 查询用户免费参与活动次数
     */
    public Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
    	Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        return selectOne("countFreeByConsumerIdAndOperatingActivityId", paramMap);
    }

    /**
     * 查询用户在时间段内免费参与活动次数
     */
    public Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
    	Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        paramMap.put("start", start);
        paramMap.put("end", end);
        return selectOne("countFreeByConsumerIdAndOperatingActivityIdAndDate", paramMap);
    }
    

	/**
	 * 根据ID查询订单
	 */
	public NgameOrdersEntity find(Long consumerId, Long id) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("id", id);
		return selectOne("find", paramMap);
	}
	
	/**
	 * 查询用户中奖某奖项次数
	 */
	public Integer countByConsumerIdAndPrizeId(Long consumerId, Long operatingActivityId, Long prizeId) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("consumerId", consumerId);
		paramMap.put("operatingActivityId", operatingActivityId);
		paramMap.put("prizeId", prizeId);
		return selectOne("countByConsumerIdAndPrizeId", paramMap);
	}
	
	/**
	 * 根据活动订单ID集合查询订单信息
	 */
	public List<NgameOrdersEntity> findByIds(Long consumerId, List<Long> ids) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("ids", ids);
		return selectList("findByIds", paramMap);
	}

	@Override
	public Integer findConsumerFreeNumber(Long consumerId,Long operatingActivityId) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        return selectOne("findConsumerFreeNumber", paramMap);
	}

	@Override
	public Integer findConsumerFreeNumberByDate(Long consumerId,Long operatingActivityId, Date start, Date end) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        paramMap.put("start", start);
        paramMap.put("end", end);
        return selectOne("findConsumerFreeNumberByDate", paramMap);
	}

	@Override
	public Integer findConsumerLimitNumber(Long consumerId,Long operatingActivityId) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        return selectOne("findConsumerLimitNumber", paramMap);
	}

	@Override
	public Integer findConsumerLimitNumberByDate(Long consumerId,Long operatingActivityId, Date start, Date end) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        paramMap.put("start", start);
        paramMap.put("end", end);
        return selectOne("findConsumerLimitNumberByDate", paramMap);
	}

	//from NgameOrdersSequenceDAOImpl in credits
	public Long getId() {
		NgameOrdersSequenceEntity seq = new NgameOrdersSequenceEntity();
		insert("getId", seq);
		return seq.getId();
	}

	@Override
	public int insert(NgameOrdersEntity ngameOrdersDto) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(ngameOrdersDto.getConsumerId());
		ngameOrdersDto.setId(this.getId());
		paramMap.put("mirror", ngameOrdersDto);
		int ret=insert("insert", paramMap);

		return ret;
	}

	/**
	 * 修改开发者订单号
	 */
	public int updateDeveloperBizId(Long consumerId,long id, String bizId) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("id", id);
		paramMap.put("bizId", bizId);
		int ret= update("updateDeveloperBizId", paramMap);
		return ret;
	}


	/**
	 * 修改抽奖订单主订单号
	 */
	public int updateMainOrderId(Long consumerId,long id, Long mainOrderId, String mainOrderNum) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("id", id);
		paramMap.put("mainOrderId", mainOrderId);
		paramMap.put("mainOrderNum", mainOrderNum);
		int ret= update("updateMainOrderId", paramMap);

		return ret;
	}

	@Override
	public int updateStatusToConsumeSuccess(Long consumerId,Long gameOrderId) {
		//加入异常捕获，防止在过度其间抛出异常，流程中断。
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("id", gameOrderId);
		paramMap.put("status", NgameOrdersDto.StatusConsumeSuccess);
		int ret= update("updateStatusToConsumeSuccess", paramMap);

		return ret;
	}

	@Override
	public int updateStatusToFail(Long consumerId,Long gameOrderId, String error4admin, String error4developer, String error4consumer) {
		//加入异常捕获，防止在过度其间抛出异常，流程中断。
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("id", gameOrderId);
		paramMap.put("status", NgameOrdersDto.StatusFail);
		paramMap.put("error4admin",subString(error4admin,200));
		paramMap.put("error4developer", subString(error4developer,200));
		paramMap.put("error4consumer", subString(error4consumer,200));
		int ret= update("updateStatusToFail", paramMap);

		return ret;
	}

	@Override
	public int updateStatusToSuccess(Long consumerId, Long gameOrderId, Long gameOrderExtraId) {
		//加入异常捕获，防止在过度其间抛出异常，流程中断。
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("id", gameOrderId);
		paramMap.put("status", NgameOrdersDto.StatusSuccess);
		paramMap.put("gameOrderExtraId", gameOrderExtraId);
		int ret= update("updateStatusToSuccess", paramMap);

		return ret;
	}

	@Override
	public int updateExchangeStatusToWaitOpen(Long consumerId, Long gameOrderId, String gameDataStr) {
		//加入异常捕获，防止在过度其间抛出异常，流程中断。
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("id", gameOrderId);
		paramMap.put("status", NgameOrdersDto.StatusSuccess);
		paramMap.put("exchangeStatus", NgameOrdersDto.ExchangeStatusWaitOpen);
		int ret= update("updateExchangeStatusToWaitOpen", paramMap);

		return ret;
	}

	@Override
	public int updateExchangeStatusToWait(Long consumerId, Long gameOrderId, String gameDataStr, Long itemId, Long appItemId, Long prizeId, String prizeType, String prizeName, String prizeFacePrice, Long couponId) {
		//加入异常捕获，防止在过度其间抛出异常，流程中断。
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("id", gameOrderId);
		paramMap.put("status", NgameOrdersDto.StatusSuccess);
		paramMap.put("exchangeStatus", NgameOrdersDto.ExchangeStatusWait);
		paramMap.put("itemId", itemId);
		paramMap.put("appItemId", appItemId);
		paramMap.put("prizeId", prizeId);
		paramMap.put("prizeType", prizeType);
		paramMap.put("prizeName", prizeName);
		paramMap.put("prizeFacePrice", prizeFacePrice);
		paramMap.put("couponId", couponId);
		int ret= update("updateExchangeStatusToWait", paramMap);

		return ret;
	}

	@Override
	public int updateExchangeStatusToOverdue(Long gameOrderId, Long consumerId, String error4admin, String error4developer, String error4consumer) {
		//加入异常捕获，防止在过度其间抛出异常，流程中断。
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("id", gameOrderId);
		paramMap.put("exchangeStatus", NgameOrdersDto.ExchangeStatusOverdue);
		paramMap.put("error4admin",subString(error4admin,200));
		paramMap.put("error4developer", subString(error4developer,200));
		paramMap.put("error4consumer", subString(error4consumer,200));
		int ret= update("updateExchangeStatusToOverdue", paramMap);

		return ret;
	}

	@Override
	public int doTakePrize(Long consumerId, Long id) {
		//加入异常捕获，防止在过度其间抛出异常，流程中断。
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("id", id);
		int ret= update("doTakePrize", paramMap);

		return ret;
	}

	@Override
	public int rollbackTakePrize(Long consumerId, Long id) {
		//加入异常捕获，防止在过度其间抛出异常，流程中断。
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("id", id);
		int ret= update("rollbackTakePrize", paramMap);

		return ret;
	}

	@Override
	public int updateManualOpenPrizeExchangeStatusToWait(Long consumerId, Long gameOrderId, Long itemId, Long appItemId, Long prizeId, String prizeType, String prizeName, String prizeFacePrice, Long couponId) {
		//加入异常捕获，防止在过度其间抛出异常，流程中断。
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("id", gameOrderId);
		paramMap.put("exchangeStatus", NgameOrdersDto.ExchangeStatusWait);
		paramMap.put("itemId", itemId);
		paramMap.put("appItemId", appItemId);
		paramMap.put("prizeId", prizeId);
		paramMap.put("prizeType", prizeType);
		paramMap.put("prizeName", prizeName);
		paramMap.put("prizeFacePrice", prizeFacePrice);
		paramMap.put("couponId", couponId);
		Calendar cal = Calendar.getInstance();
		cal.setTime(new Date());
		cal.add(Calendar.DATE, +7);
		Date prizeOverdueDate = cal.getTime();
		paramMap.put("prizeOverdueDate", prizeOverdueDate);
		int ret= update("updateManualOpenPrizeExchangeStatusToWait", paramMap);

		return ret;
	}

	@Override
	public int updateExchangeStatusToFail(Long consumerId, Long gameOrderId, String error4admin, String error4developer, String error4consumer) {
		//加入异常捕获，防止在过度其间抛出异常，流程中断。
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("id", gameOrderId);
		paramMap.put("exchangeStatus", NgameOrdersDto.ExchangeStatusFail);
		paramMap.put("error4admin",subString(error4admin,200));
		paramMap.put("error4developer", subString(error4developer,200));
		paramMap.put("error4consumer", subString(error4consumer,200));
		int ret= update("updateExchangeStatusToFail", paramMap);

		return ret;
	}

	@Override
	public int updateExchangeStatusToWaitOpenAndExtraId(Long consumerId, Long gameOrderId, String gameDataStr, Long gameOrderExtraId) {
		//加入异常捕获，防止在过度其间抛出异常，流程中断。
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("id", gameOrderId);
		paramMap.put("status", NgameOrdersDto.StatusSuccess);
		paramMap.put("exchangeStatus", NgameOrdersDto.ExchangeStatusWaitOpen);
		paramMap.put("gameOrderExtraId", gameOrderExtraId);
		int ret= update("updateExchangeStatusToWaitOpenAndExtraId", paramMap);

		return ret;
	}
	
	@Override
    public int updateExchangeStatusToWaitOpenAndExtraIdForLuck(Long consumerId, Long gameOrderId, Long gameOrderExtraId) {
		//加入异常捕获，防止在过度其间抛出异常，流程中断。
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("id", gameOrderId);
		paramMap.put("status", NgameOrdersDto.StatusSuccess);
		paramMap.put("exchangeStatus", NgameOrdersDto.ExchangeStatusWaitOpen);
		paramMap.put("gameOrderExtraId", gameOrderExtraId);
		int ret= update("updateExchangeStatusToWaitOpenAndExtraId", paramMap);
		return ret;
    }

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.NGAME_CON;
	}
}
