package cn.com.duiba.activity.center.biz.dao.quizz.impl;

import java.util.*;

import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.quizz.DuibaQuizzDao;
import cn.com.duiba.activity.center.biz.entity.AddActivityEntity;
import cn.com.duiba.activity.center.biz.entity.quizz.DuibaQuizzEntity;

@Repository
public class DuibaQuizzDaoImpl extends ActivityBaseDao implements DuibaQuizzDao {

    @Override
    public DuibaQuizzEntity find(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return selectOne("find", paramMap);
    }

    @Override
    public List<DuibaQuizzEntity> findByPage(Integer offset, Integer max) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("offset", offset);
        paramMap.put("max", max);
        return selectList("findByPage", paramMap);
    }

    @Override
    public List<DuibaQuizzEntity> findByPage(Map<String, Object> paramMap) {
        return selectList("findByPage", paramMap);
    }

    @Override
    public Long findPageCount(Map<String, Object> paramMap) {
        return selectOne("findPageCount", paramMap);
    }

    @Override
    public int updateStatus(Long id, int status) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("status", status);
        return update("updateStatus", paramMap);
    }

    @Override
    public int delete(Long id) {
        return update("delete", id);
    }

    @Override
    public Integer insert(DuibaQuizzEntity DuibaQuizzEntity) {
        return insert("insert", DuibaQuizzEntity);
    }

    @Override
    public int updateInfoForm(DuibaQuizzEntity DuibaQuizzEntity) {
        return update("updateInfoForm", DuibaQuizzEntity);
    }
	
	@Override
    public int updateTagById(Long id, String tag) {
	    Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("tag", tag);
        return update("updateTagById",paramMap);
    }

    @Override
    public Integer updateSwitches(Long id, Long switches) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("switches", switches);
        return update("updateSwitches", paramMap);
    }

    public int updateAutoOffDateNull(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return update("updateAutoOffDateNull", paramMap);
    }

    @Override
    public List<DuibaQuizzEntity> findAutoOff() {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(new Date());
        cal1.add(Calendar.DATE, -1);
        Date startTime = cal1.getTime();

        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("startTime", startTime);
        paramMap.put("endTime", new Date());
        return selectList("findAutoOff", paramMap);
    }

    @Override
    public List<DuibaQuizzEntity> findAllByIds(List<Long> ids) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("ids", ids);
        return selectList("findAllByIds", paramMap);
    }

    public List<AddActivityEntity> findAllQuizz() {
        // Map<String, Object> paramMap = new HashMap<String, Object>();
        // paramMap.put("appId", appId);
        return selectList("findAllQuizz");
    }

    @Override
    public Integer update(DuibaQuizzEntity DuibaQuizzEntity) {
        return update("update", DuibaQuizzEntity);
    }
	
	@Override
    public String findTagById(Long id) {
        return selectOne("findTagById", id);
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.QUIZZ;
    }
}
