package cn.com.duiba.activity.center.biz.dao.quizz.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.quizz.DuibaQuizzStockDao;
import cn.com.duiba.activity.center.biz.entity.quizz.DuibaQuizzStockEntity;

import com.google.common.collect.Maps;

@Repository
public class DuibaQuizzStockDaoImpl extends ActivityBaseDao implements DuibaQuizzStockDao {

    @Override
    public int subStock(Long id, Integer subNumber) {
        Map<String, Object> paramMap = new HashMap<String, Object>(2);
        paramMap.put("id", id);
        paramMap.put("subNumber", subNumber);
        return update("subStock", paramMap);
    }

    @Override
    public int addStock(Long id, Integer addNumber) {
        Map<String, Object> paramMap = new HashMap<String, Object>(2);
        paramMap.put("id", id);
        paramMap.put("addNumber", addNumber);
        return update("addStock", paramMap);
    }

    @Override
    public DuibaQuizzStockEntity findRemaining(Long questionOptionId) {
        Map<String, Object> paramMap = new HashMap<String, Object>(1);
        paramMap.put("optionId", questionOptionId);
        return selectOne("findRemaining", paramMap);
    }


    //from manager
    @Override
    public DuibaQuizzStockEntity findByQuizzOptionId(Long quizzOptionId) {
        return selectOne("findByQuizzOptionId", quizzOptionId);
    }
    
    @Override
    public DuibaQuizzStockEntity findById(Long id){
    	return selectOne("findById", id);
    }

    @Override
    public List<DuibaQuizzStockEntity> findByQuizzOptionIds(List<Long> list) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("list", list);
        return selectList("findByQuizzOptionIds", params);
    }

    @Override
    public int updateStockAdd(Long id, Integer stockAdd) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        params.put("stockAdd", stockAdd);
        return update("updateStockAdd", params);
    }

    @Override
    public int updateStockSub(Long id, Integer stockSub) {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        params.put("stockSub", stockSub);
        return update("updateStockSub", params);
    }

    @Override
    public void add(DuibaQuizzStockEntity quizzStockDO) {
        insert("add", quizzStockDO);
    }

    @Override
    public void addBatch(List<DuibaQuizzStockEntity> list) {
        Map<String, Object> params = Maps.newHashMap();
        params.put("list", list);
        insert("addBatch", params);
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.QUIZZ;
    }
}
