package cn.com.duiba.activity.center.biz.kafka;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class HdtoolMQSend {
    private static Logger log = LoggerFactory.getLogger(HdtoolMQSend.class);

    @Autowired
    private MessageService messageService;

    @Autowired
    private TopicConstant topicConstant;

    public void hdtoolSendDataSync(final Long consumerId, final Long hdOrderId) {
        try {
            DataSyncMessage message = new DataSyncMessage();
            message.setConsumerId(consumerId);
            message.setSubOrderId(hdOrderId);

            log.info("hdtoolSendDataSync : consumerId: " + consumerId + "  hdOrderId: " + hdOrderId);
            {
                messageService.sendMsg(topicConstant.getTopicHdtoolDataSync(), message);
            }
        } catch (Exception e) {
            log.error("hdtool   send message is error [hdtoolSendDataSync] : consumerId: " + consumerId + "  hdOrderId: " + hdOrderId, e);
        }

    }

}
