package cn.com.duiba.activity.center.biz.kafka;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class NgameMQSend {
	private static Logger log = LoggerFactory.getLogger(NgameMQSend.class);

	@Autowired
	private MessageService messageService;

	@Autowired
	private TopicConstant topicConstant;

	public void ngameSendDataSync(final Long consumerId, final Long ngameOrderId) {

		try {
			DataSyncMessage message = new DataSyncMessage();
			message.setConsumerId(consumerId);
			message.setSubOrderId(ngameOrderId);

			log.info("ngameSendDataSync : consumerId: " + consumerId + "  ngameOrderId: " + ngameOrderId);
			{
				messageService.sendMsg(topicConstant.getTopicNgameDataSync(), message);
			}
		} catch (Exception e) {
			log.error("ngame   send message is error ", e);
		}

	}

}
