package cn.com.duiba.activity.center.biz.kafka;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QuizzMQSend {

    private static Logger  log = LoggerFactory.getLogger(QuizzMQSend.class);

    @Autowired
    private MessageService messageService;

    @Autowired
    private TopicConstant  topicConstant;

    public void quizzSendDataSync(final Long consumerId, final Long quizzOrderId) {

        try {
            DataSyncMessage message = new DataSyncMessage();
            message.setConsumerId(consumerId);
            message.setSubOrderId(quizzOrderId);

            log.info("quizzSendDataSync : consumerId: " + consumerId + "  quizzOrderId: " + quizzOrderId);
            {
                messageService.sendMsg(topicConstant.getTopicQuizzDataSync(), message);
            }
        } catch (Exception e) {
            log.error("hdtool   send message is error ", e);
        }

    }

}
