package cn.com.duiba.activity.center.biz.remoteservice.impl.chaos;

import cn.com.duiba.activity.center.api.dto.chaos.ActPreStockDto;
import cn.com.duiba.activity.center.api.remoteservice.chaos.RemoteActPreStockService;
import cn.com.duiba.activity.center.biz.service.chaos.ActPreStockSerivce;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by yansen on 16/6/22.
 */
@Service
public class RemoteActPreStockServiceImpl implements RemoteActPreStockService {
    @Resource
    private ActPreStockSerivce actPreStockService;

    @Override
    public void addAppActPreStock(Long configId, Long prizeId, Long quantity, String name, String relationType, Long appId) {
        actPreStockService.addAppActPreStock(configId, prizeId, quantity, name, relationType, appId);
    }

    @Override
    public void addShareActPreStock(Long configId, Long prizeId, Long quantity, String name, String relationType) {
        actPreStockService.addShareActPreStock(configId, prizeId, quantity, name, relationType);
    }

    @Override
    public int refreshActPreStock(Long prizeId, String relationType, Long appId, Long quantity, String name) {
        return actPreStockService.refreshActPreStock(prizeId, relationType, appId, quantity, name);
    }

    @Override
    public int deleteActStock(Long configId, String relationType) {
        return actPreStockService.deleteActStock(configId, relationType);
    }

    @Override
    public int deleteActPrizeStock(Long configId, Long prizeId, String relationType) {
        return actPreStockService.deleteActPrizeStock(configId, prizeId, relationType);
    }

    @Override
    public int deleteActStockAppId(Long prizeId, String relationType, Long appId) {
        return actPreStockService.deleteActStockAppId(prizeId, relationType, appId);
    }

    @Override
    public ActPreStockDto findPreStock(Long prizeId, String relationType, Long appId) {
        return actPreStockService.findPreStock(prizeId, relationType, appId);
    }

    @Override
    public List<ActPreStockDto> findPreStock(Long configId, String relationType) {
        return actPreStockService.findPreStock(configId, relationType);
    }

    @Override
    public ActPreStockDto findPreStockByApp(Long relationPrizeId, String relationType, Long appId) {
        return actPreStockService.findPreStockByApp(relationPrizeId, relationType, appId);
    }

    @Override
    public ActPreStockDto findPreStockByShare(Long relationPrizeId, String relationType) {
        return actPreStockService.findPreStockByShare(relationPrizeId, relationType);
    }

    @Override
    public ActPreStockDto findByLock(Long id) {
        return actPreStockService.findByLock(id);
    }

    @Override
    public int decrementRemaining(Long id) {
        return actPreStockService.decrementRemaining(id);
    }

    @Override
    public int incrementRemaining(Long id) {
        return actPreStockService.incrementRemaining(id);
    }

    @Override
    public int addRemainingById(Long id, Long addRemaining) {
        return actPreStockService.addRemainingById(id, addRemaining);
    }

    @Override
    public int subRemainingById(Long id, Long subRemaining) {
        return actPreStockService.subRemainingById(id, subRemaining);
    }

    @Override
    public ActPreStockDto insert(ActPreStockDto actPreStockDto) {
        actPreStockService.insert(actPreStockDto);
        return actPreStockDto;
    }

    @Override
    public int update(ActPreStockDto actPreStockDto) {
        return actPreStockService.update(actPreStockDto);
    }

    @Override
    public List<ActPreStockDto> findActStockByConfigId(Long configId, String relationType) {
        return BeanUtils.copyList(actPreStockService.findActStockByConfigId(configId, relationType),ActPreStockDto.class);
    }
}
