package cn.com.duiba.activity.center.biz.remoteservice.impl.duibaactivity;

import cn.com.duiba.activity.center.api.dto.duibaactivity.DuibaActivityAppSpecifyDto;
import cn.com.duiba.activity.center.api.remoteservice.duibaactivity.RemoteDuibaActivityAppSpecifyService;
import cn.com.duiba.activity.center.biz.service.duibaactivity.DuibaActivityAppSpecifyService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/6/23.
 */
@Service
public class RemoteDuibaActivityAppSpecifyServiceImpl implements RemoteDuibaActivityAppSpecifyService {
    @Resource
    private DuibaActivityAppSpecifyService duibaActivityAppSpecifyService;

    @Override
    public List<DuibaActivityAppSpecifyDto> findDuiBaActivitySpecifyDO(Long duibaActivityId) {
        return duibaActivityAppSpecifyService.findDuiBaActivitySpecifyDO(duibaActivityId);
    }

    @Override
    public void delete(Long id) {
        duibaActivityAppSpecifyService.delete(id);
    }

    @Override
    public DuibaActivityAppSpecifyDto findByDuibaActivityAndApp(Long duibaActivityId, Long appId) {
        return duibaActivityAppSpecifyService.findByDuibaActivityAndApp(duibaActivityId, appId);
    }

    @Override
    public Map<Long,DuibaActivityAppSpecifyDto> findByDuibaActivitysAndApp(List<Long> duibaActivityIds, Long appId){
        return duibaActivityAppSpecifyService.findByDuibaActivitysAndApp(duibaActivityIds, appId);
    }

    @Override
    public void insert(DuibaActivityAppSpecifyDto duibaActivityAppSpecifyDO) {
        duibaActivityAppSpecifyService.insert(duibaActivityAppSpecifyDO);
    }

    @Override
    public DuibaActivityAppSpecifyDto find(Long id) {
        return duibaActivityAppSpecifyService.find(id);
    }
}
