package cn.com.duiba.activity.center.biz.remoteservice.impl.manual;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.manual.ManualLotteryOrderDto;
import cn.com.duiba.activity.center.api.remoteservice.manual.RemoteManualOrderLotteryService;
import cn.com.duiba.activity.center.biz.service.manual.ManualOrderLotteryService;

@Service
public class RemoteManualOrderLotteryServiceImpl implements
		RemoteManualOrderLotteryService {

	@Autowired
	private ManualOrderLotteryService manualOrderLotteryService;
	
	@Override
	public Integer countByConsumerIdAndOperatingActivityId(Long consumerId,
			Long operatingActivityId) {
		return manualOrderLotteryService.countByConsumerIdAndOperatingActivityId(consumerId, operatingActivityId);
	}

	@Override
	public Integer countByConsumerIdAndOperatingActivityIdAndDate(
			Long consumerId, Long operatingActivityId, Date start, Date end) {
		return manualOrderLotteryService.countByConsumerIdAndOperatingActivityIdAndDate(consumerId, operatingActivityId, start, end);
	}

	@Override
	public Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId,
			Long operatingActivityId) {
		return manualOrderLotteryService.countFreeByConsumerIdAndOperatingActivityId(consumerId, operatingActivityId);
	}

	@Override
	public Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(
			Long consumerId, Long operatingActivityId, Date start, Date end) {
		return manualOrderLotteryService.countFreeByConsumerIdAndOperatingActivityIdAndDate(consumerId, operatingActivityId, start, end);
	}

	@Override
	public List<ManualLotteryOrderDto> findAllOpenManualLotteryByCondition(
			Map<String, Object> paramMap) {
		return manualOrderLotteryService.findAllOpenManualLotteryByCondition(paramMap);
	}

	@Override
	public Long findAllOpenManualLotteryCount(Map<String, Object> paramMap) {
		return manualOrderLotteryService.findAllOpenManualLotteryCount(paramMap);
	}

	@Override
	public List<ManualLotteryOrderDto> findWardList(Long operatingActivityId) {
		return manualOrderLotteryService.findWardList(operatingActivityId);
	}

	@Override
	public List<ManualLotteryOrderDto> findNoWardList(
			Map<String, Object> paramMap) {
		return manualOrderLotteryService.findNoWardList(paramMap);
	}

	@Override
	public Long findNoWardListCount(Map<String, Object> paramMap) {
		return manualOrderLotteryService.findNoWardListCount(paramMap);
	}

	@Override
	public List<ManualLotteryOrderDto> findStartOpenListByIds(
			Map<String, Object> paramMap) {
		return manualOrderLotteryService.findStartOpenListByIds(paramMap);
	}

	@Override
	public int updateAward(Long id, Long activityId, Date date) {
		return manualOrderLotteryService.updateAward(id, activityId, date);
	}

	@Override
	public ManualLotteryOrderDto randomFindManualLottery(
			Map<String, Object> paramMap) {
		return manualOrderLotteryService.randomFindManualLottery(paramMap);
	}

	@Override
	public void updateNoAwardList(Map<String, Object> paramMap) {
		manualOrderLotteryService.updateNoAwardList(paramMap);
	}

	@Override
	public List<ManualLotteryOrderDto> findAllNoAwardList(
			Map<String, Object> paramMap) {
		return manualOrderLotteryService.findAllNoAwardList(paramMap);
	}

	@Override
	public List<ManualLotteryOrderDto> findAllByIds(List<Long> ids) {
		return manualOrderLotteryService.findAllByIds(ids);
	}

	@Override
	public ManualLotteryOrderDto findByOrderId(Long orderId) {
		return manualOrderLotteryService.findByOrderId(orderId);
	}

	@Override
	public ManualLotteryOrderDto findByAppAndDeveloperBizId(Long appId,
			String bizId) {
		return manualOrderLotteryService.findByAppAndDeveloperBizId(appId, bizId);
	}

	@Override
	public ManualLotteryOrderDto insert(ManualLotteryOrderDto ManualLotteryOrderDto) {
		manualOrderLotteryService.insert(ManualLotteryOrderDto);
		return ManualLotteryOrderDto;
	}

	@Override
	public void update(ManualLotteryOrderDto ManualLotteryOrderDto) {
		manualOrderLotteryService.update(ManualLotteryOrderDto);
	}

	@Override
	public ManualLotteryOrderDto find(Long id) {
		return manualOrderLotteryService.find(id);
	}

}
