package cn.com.duiba.activity.center.biz.remoteservice.impl.ngame;

import cn.com.duiba.activity.center.api.dto.ngame.DuibaNgameBrickDto;
import cn.com.duiba.activity.center.api.remoteservice.ngame.RemoteDuibaNgameBrickService;
import cn.com.duiba.activity.center.biz.service.ngame.DuibaNgameBrickService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by wenqi.huang on 16/6/15.
 */
@Service
public class RemoteDuibaNgameBrickServiceImpl implements RemoteDuibaNgameBrickService {
    @Resource
    private DuibaNgameBrickService duibaNgameBrickService;

    @Override
    public DuibaNgameBrickDto find(Long id) {
        return duibaNgameBrickService.find(id);
    }

    @Override
    public DuibaNgameBrickDto insert(DuibaNgameBrickDto duibaNgameBrickDto) {
        duibaNgameBrickService.insert(duibaNgameBrickDto);
        return duibaNgameBrickDto;
    }

    @Override
    public void update4Admin(DuibaNgameBrickDto duibaNgameBrickDto) {
        duibaNgameBrickService.update4Admin(duibaNgameBrickDto);
    }

    @Override
    public DuibaNgameBrickDto findByTitle(String title) {
        return duibaNgameBrickService.findByTitle(title);
    }

    @Override
    public void open(Long id) {
        duibaNgameBrickService.open(id);
    }

    @Override
    public void disable(Long id) {
        duibaNgameBrickService.disable(id);
    }

    @Override
    public List<DuibaNgameBrickDto> findPage(Integer offset, Integer max) {
        return duibaNgameBrickService.findPage(offset, max);
    }

    @Override
    public Long findPageCount() {
        return duibaNgameBrickService.findPageCount();
    }

    @Override
    public List<DuibaNgameBrickDto> findAll() {
        return duibaNgameBrickService.findAll();
    }

    @Override
    public String getBrickContentById(Long id) {
        return duibaNgameBrickService.getBrickContentById(id);
    }

    @Override
    public DuibaNgameBrickDto findNoContent(Long id) {
        return duibaNgameBrickService.findNoContent(id);
    }
}
