package cn.com.duiba.activity.center.biz.remoteservice.impl.quizz;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzAppSpecifyDto;
import cn.com.duiba.activity.center.api.remoteservice.quizz.RemoteDuibaQuizzAppSpecifyServiceInner;
import cn.com.duiba.activity.center.biz.service.quizz.DuibaQuizzAppSpecifyService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by xuezhaoming on 16/6/14.
 */
@Service
public class RemoteDuibaQuizzAppSpecifyServiceImpl implements RemoteDuibaQuizzAppSpecifyServiceInner {

    @Resource
    private DuibaQuizzAppSpecifyService duibaQuizzAppSpecifyService;

    @Override
    public DubboResult<List<DuibaQuizzAppSpecifyDto>> findByDuibaQuizzId(Long duibaQuizzId) {
        return DubboResult.successResult(duibaQuizzAppSpecifyService.findByDuibaQuizzId(duibaQuizzId));
    }

    @Override
    public void delete(Long id) {
        duibaQuizzAppSpecifyService.delete(id);
    }

    @Override
    public DuibaQuizzAppSpecifyDto insert(DuibaQuizzAppSpecifyDto duibaQuizzAppSpecifyDto) {
        duibaQuizzAppSpecifyService.insert(duibaQuizzAppSpecifyDto);
        return duibaQuizzAppSpecifyDto;
    }

    @Override
    public DubboResult<DuibaQuizzAppSpecifyDto> findByDuibaQuizzAndApp(Long duibaQuizzId, Long appId) {
        return DubboResult.successResult(duibaQuizzAppSpecifyService.findByDuibaQuizzAndApp(duibaQuizzId, appId));
    }

    public DubboResult<Map<Long, DuibaQuizzAppSpecifyDto>> findByDuibaQuizzsAndApp(List<Long> duibaQuizzIds, Long appId){
        return DubboResult.successResult(duibaQuizzAppSpecifyService.findByDuibaQuizzsAndApp(duibaQuizzIds, appId));
    }

    @Override
    public DubboResult<DuibaQuizzAppSpecifyDto> find(Long id) {
        return DubboResult.successResult(duibaQuizzAppSpecifyService.find(id));
    }

    @Override
    public DubboResult<DuibaQuizzAppSpecifyDto> findByQuizzIdAndAppId(Long quizzId, Long appId) {
        return DubboResult.successResult(duibaQuizzAppSpecifyService.findByQuizzIdAndAppId(quizzId, appId));
    }
}
