package cn.com.duiba.activity.center.biz.remoteservice.impl.quizz;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzStockDto;
import cn.com.duiba.activity.center.api.remoteservice.quizz.RemoteDuibaQuizzStockService;
import cn.com.duiba.activity.center.biz.service.quizz.DuibaQuizzStockService;

@Service
public class RemoteDuibaQuizzStockServiceImpl implements
		RemoteDuibaQuizzStockService {
	@Autowired
	private DuibaQuizzStockService duibaQuizzStockService;

	@Override
	public int subStock(Long id, Integer subNumber) {
		return duibaQuizzStockService.subStock(id, subNumber);
	}

	@Override
	public int addStock(Long id, Integer addNumber) {
		return duibaQuizzStockService.addStock(id, addNumber);
	}

	@Override
	public DuibaQuizzStockDto findRemaining(Long optionId) {
		return duibaQuizzStockService.findRemaining(optionId);
	}

	@Override
	public DuibaQuizzStockDto findByQuizzOptionId(Long questionOptionId) {
		return duibaQuizzStockService.findByQuizzOptionId(questionOptionId);
	}

	@Override
	public List<DuibaQuizzStockDto> findByQuizzOptionIds(List<Long> list) {
		return duibaQuizzStockService.findByQuizzOptionIds(list);
	}

	@Override
	public int updateStockAdd(Long id, Integer stockAdd) {
		return duibaQuizzStockService.updateStockAdd(id, stockAdd);
	}

	@Override
	public int updateStockSub(Long id, Integer stockSub) {
		return duibaQuizzStockService.updateStockSub(id, stockSub);
	}

	@Override
	public DuibaQuizzStockDto add(DuibaQuizzStockDto quizzStockDO) {
		duibaQuizzStockService.add(quizzStockDO);
		return quizzStockDO;
	}

	@Override
	public List<DuibaQuizzStockDto> addBatch(List<DuibaQuizzStockDto> list) {
		return duibaQuizzStockService.addBatch(list);
	}
	
	@Override
	public DuibaQuizzStockDto findById(Long id){
		return duibaQuizzStockService.findById(id);
	}

}
