package cn.com.duiba.activity.center.biz.service.activity.Impl;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityOptionsDto;
import cn.com.duiba.activity.center.biz.dao.DsConstants;
import cn.com.duiba.activity.center.biz.dao.activity.OperatingActivityOptionsDao;
import cn.com.duiba.activity.center.biz.entity.activity.OperatingActivityOptionsEntity;
import cn.com.duiba.activity.center.biz.service.activity.OperatingActivityOptionsService;
import cn.com.duiba.activity.center.biz.support.CacheConstants;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.base.Preconditions;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * Created by yansen on 16/6/12.
 */
@Service
public class OperatingActivityOptionsServiceImpl implements OperatingActivityOptionsService {
    @Resource
    private OperatingActivityOptionsDao operatingActivityOptionsDao;


    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyById(Long id) {
        return CacheConstants.KEY_OPERATING_ACTIVITY_OPTIONS_BY_ID + id;
    }

    @Override
    public OperatingActivityOptionsDto findOptionById(final Long id) {
        return cacheClient.getWithCacheLoader(getCacheKeyById(id), 5, TimeUnit.MINUTES, new CacheLoader<OperatingActivityOptionsDto>() {
            @Override
            public OperatingActivityOptionsDto load() {
                return BeanUtils.copy(operatingActivityOptionsDao.findOptionById(id),OperatingActivityOptionsDto.class);
            }
        });
    }

    @Override
    public List<OperatingActivityOptionsDto> findByOperatingActivityId(Long operatingActivityId) {
        List<OperatingActivityOptionsEntity> entities=operatingActivityOptionsDao.findByOperatingActivityId(operatingActivityId);
        if(CollectionUtils.isEmpty(entities)){
            return Collections.emptyList();
        }
        List<OperatingActivityOptionsDto> dtoList=new ArrayList<>(entities.size());
        for(OperatingActivityOptionsEntity entity:entities){
            dtoList.add(copyEntity(entity));
        }
        return dtoList;
    }

    @Override
    public Integer countByOperatingActivityId(Long operatingActivityId) {
        return operatingActivityOptionsDao.countByOperatingActivityId(operatingActivityId);
    }

    @Override
    public int decrementOptionRemaining(Long optionId) {
        int result= operatingActivityOptionsDao.decrementOptionRemaining(optionId);
        cacheClient.remove(getCacheKeyById(optionId));
        return result;
    }

    @Override
    public int incrementOptionRemaining(Long optionId) {
        int result= operatingActivityOptionsDao.incrementOptionRemaining(optionId);
        cacheClient.remove(getCacheKeyById(optionId));
        return result;
    }

    @Override
    public int updateOptionDeleteStatus(List<Long> oaoList) {
        int result =operatingActivityOptionsDao.updateOptionDeleteStatus(oaoList);
        for(Long id:oaoList){
            cacheClient.remove(getCacheKeyById(id));
        }
        return result;
    }

    @Override
    public int updatePrize(OperatingActivityOptionsDto operatingActivityOptionsDto) {
        Preconditions.checkNotNull(operatingActivityOptionsDto);
        int result= operatingActivityOptionsDao.updatePrize(copyDto(operatingActivityOptionsDto));
        cacheClient.remove(getCacheKeyById(operatingActivityOptionsDto.getId()));
        return result;
    }

    @Override
    public void insertOption(OperatingActivityOptionsDto operatingActivityOptionsDto) {
        Preconditions.checkNotNull(operatingActivityOptionsDto);
        OperatingActivityOptionsEntity entity=new OperatingActivityOptionsEntity(true);
        BeanUtils.copy(operatingActivityOptionsDto,entity);
        operatingActivityOptionsDao.insertOption(entity);
        operatingActivityOptionsDto.setId(entity.getId());
    }

    @Override
    public int updateOption(OperatingActivityOptionsDto operatingActivityOptionsDto) {
        Preconditions.checkNotNull(operatingActivityOptionsDto);
        OperatingActivityOptionsEntity entity=new OperatingActivityOptionsEntity(operatingActivityOptionsDto.getId());
        BeanUtils.copy(operatingActivityOptionsDto,entity);
        int result= operatingActivityOptionsDao.updateOption(entity);
        cacheClient.remove(getCacheKeyById(operatingActivityOptionsDto.getId()));
        return result;
    }

    @Override
    @Transactional(value= DsConstants.DATABASE_CREDITS)
    public OperatingActivityOptionsDto findForupdate(Long id) {
        OperatingActivityOptionsEntity entity= operatingActivityOptionsDao.findForupdate(id);
        return copyEntity(entity);
    }

    @Override
    public int addRemainingById(Long id, Integer addRemaining) {
        int result= operatingActivityOptionsDao.addRemainingById(id, addRemaining);
        cacheClient.remove(getCacheKeyById(id));
        return result;
    }

    @Override
    public int subRemainingById(Long id, Integer subRemaining) {
        int result= operatingActivityOptionsDao.subRemainingById(id, subRemaining);
        cacheClient.remove(getCacheKeyById(id));
        return result;
    }

    @Override
    public int updateRemainingById(Long id, Integer remaining) {
        int result= operatingActivityOptionsDao.updateRemainingById(id, remaining);
        cacheClient.remove(getCacheKeyById(id));
        return result;
    }

    @Override
    @Transactional(value= DsConstants.DATABASE_CREDITS)
    public Integer findRemaingForupdate(Long id) {
        return operatingActivityOptionsDao.findRemaingForupdate(id);
    }

    private OperatingActivityOptionsDto copyEntity(OperatingActivityOptionsEntity entity){
        if (entity == null) {
            return null;
        }
        OperatingActivityOptionsDto dto = new OperatingActivityOptionsDto();
        BeanUtils.copy(entity, dto);
        return dto;
    }

    private OperatingActivityOptionsEntity copyDto(OperatingActivityOptionsDto dto){
        if(dto==null){
            return null;
        }
        OperatingActivityOptionsEntity entity=new OperatingActivityOptionsEntity();
        BeanUtils.copy(dto,entity);
        return entity;
    }
}
