package cn.com.duiba.activity.center.biz.service.game.impl;

import cn.com.duiba.activity.center.api.dto.DeveloperActivityStatisticsDto;
import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerOrdersDto;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionAnswerOrdersDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionAnswerOrdersEntity;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionAnswerOrdersService;
import cn.com.duiba.activity.center.biz.support.CacheConstants;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import static cn.com.duiba.wolf.utils.BeanUtils.copy;

/**
 * Created by wenqi.huang on 16/6/1.
 */
@Service
public class DuibaQuestionAnswerOrdersServiceImpl implements DuibaQuestionAnswerOrdersService {
    @Resource
    private DuibaQuestionAnswerOrdersDao duibaQuestionAnswerOrdersDao;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyById(Long id){
        return CacheConstants.KEY_DUIBA_QUESTION_ANSWER_ORDERS_BY_ID + id;
    }

    @Override
    public void insert(DuibaQuestionAnswerOrdersDto order) {
        DuibaQuestionAnswerOrdersEntity e = copy(order, DuibaQuestionAnswerOrdersEntity.class);
        duibaQuestionAnswerOrdersDao.insert(e);
        order.setId(e.getId());
    }

    @Override
    public void updateStatusToConsumeSuccess(Long id) {
        duibaQuestionAnswerOrdersDao.updateStatusToConsumeSuccess(id);
        cacheClient.remove(getCacheKeyById(id));
    }

    @Override
    public DuibaQuestionAnswerOrdersDto find(Long id) {
        String key = getCacheKeyById(id);
        DuibaQuestionAnswerOrdersDto dto = cacheClient.get(key);
        if(dto == null) {
            dto = BeanUtils.copy(duibaQuestionAnswerOrdersDao.find(id), DuibaQuestionAnswerOrdersDto.class);
            cacheClient.set(key, dto, 1, TimeUnit.HOURS);
        }
        return dto;
    }

    @Override
    public void updateStatusToConsumeFail(Long id, String error4admin, String error4developer, String error4consumer) {
        duibaQuestionAnswerOrdersDao.updateStatusToConsumeFail(id, error4admin, error4developer, error4consumer);
        cacheClient.remove(getCacheKeyById(id));
    }

    @Override
    public void updateStatusToSuccess(Long id) {
        duibaQuestionAnswerOrdersDao.updateStatusToSuccess(id);
        cacheClient.remove(getCacheKeyById(id));
    }

    @Override
    public void updateDeveloperBizId(Long questionOrderId, String bizId) {
        duibaQuestionAnswerOrdersDao.updateDeveloperBizId(questionOrderId, bizId);
        cacheClient.remove(getCacheKeyById(questionOrderId));
    }

    @Override
    public Integer countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        return duibaQuestionAnswerOrdersDao.countByConsumerIdAndOperatingActivityId(consumerId, operatingActivityId);
    }

    @Override
    public Integer countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        return duibaQuestionAnswerOrdersDao.countByConsumerIdAndOperatingActivityIdAndDate(consumerId, operatingActivityId, start, end);
    }

    @Override
    public Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        return duibaQuestionAnswerOrdersDao.countFreeByConsumerIdAndOperatingActivityId(consumerId, operatingActivityId);
    }

    @Override
    public Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        return duibaQuestionAnswerOrdersDao.countFreeByConsumerIdAndOperatingActivityIdAndDate(consumerId, operatingActivityId, start, end);
    }

    @Override
    public void updateExchangeStatusToFail(Long questionOrderId, String error4admin, String error4developer, String error4consumer) {
        duibaQuestionAnswerOrdersDao.updateExchangeStatusToFail(questionOrderId, error4admin, error4developer, error4consumer);
        cacheClient.remove(getCacheKeyById(questionOrderId));
    }

    @Override
    public void updateMainOrderId(Long questionOrderId, Long mainOrderId, String mainOrderNum) {
        duibaQuestionAnswerOrdersDao.updateMainOrderId(questionOrderId, mainOrderId, mainOrderNum);
        cacheClient.remove(getCacheKeyById(questionOrderId));
    }

    @Override
    public int updateExchangeStatusToOverdue(Long questionOrderId, String error4admin, String error4developer, String error4consumer) {
        int ret = duibaQuestionAnswerOrdersDao.updateExchangeStatusToOverdue(questionOrderId, error4admin, error4developer, error4consumer);
        cacheClient.remove(getCacheKeyById(questionOrderId));
        return ret;
    }

    @Override
    public int updateExchangeStatusToSucess(Long questionOrderId, String error4admin, String error4developer, String error4consumer) {
        int ret = duibaQuestionAnswerOrdersDao.updateExchangeStatusToSucess(questionOrderId, error4admin, error4developer, error4consumer);
        cacheClient.remove(getCacheKeyById(questionOrderId));
        return ret;
    }

    @Override
    public int updateExchangeStatusToWait(Long questionOrderId, String error4admin, String error4developer, String error4consumer) {
        int ret = duibaQuestionAnswerOrdersDao.updateExchangeStatusToWait(questionOrderId, error4admin, error4developer, error4consumer);
        cacheClient.remove(getCacheKeyById(questionOrderId));
        return ret;
    }

    @Override
    public int doTakePrize(Long questionOrderId) {
        int ret = duibaQuestionAnswerOrdersDao.doTakePrize(questionOrderId);
        cacheClient.remove(getCacheKeyById(questionOrderId));
        return ret;
    }

    @Override
    public void rollbackTakePrize(Long questionOrderId) {
        duibaQuestionAnswerOrdersDao.rollbackTakePrize(questionOrderId);
        cacheClient.remove(getCacheKeyById(questionOrderId));
    }

    @Override
    public List<Long> findOverdueOrder() {
        return duibaQuestionAnswerOrdersDao.findOverdueOrder();
    }

    @Override
    public List<DuibaQuestionAnswerOrdersDto> findByIds(List<Long> questionIds) {
        return BeanUtils.copyList(duibaQuestionAnswerOrdersDao.findByIds(questionIds), DuibaQuestionAnswerOrdersDto.class);
    }

    @Override
    public void updatePrizeInfo(DuibaQuestionAnswerOrdersDto questionOrdersDO) {
        duibaQuestionAnswerOrdersDao.updatePrizeInfo(copy(questionOrdersDO, DuibaQuestionAnswerOrdersEntity.class));
        cacheClient.remove(getCacheKeyById(questionOrdersDO.getId()));
    }

    @Override
    public void updateScore(Long orderId, Integer rightCount) {
        duibaQuestionAnswerOrdersDao.updateScore(orderId, rightCount);
        cacheClient.remove(getCacheKeyById(orderId));
    }

    @Override
    public DuibaQuestionAnswerOrdersDto findByAppAndDeveloperBizId(Long appId, String bizId) {
        return copy(duibaQuestionAnswerOrdersDao.findByAppAndDeveloperBizId(appId, bizId), DuibaQuestionAnswerOrdersDto.class);
    }

    @Override
    public List<DuibaQuestionAnswerOrdersDto> findQuestionOrderLimit50(Long appId, Long activityId) {
        return BeanUtils.copyList(duibaQuestionAnswerOrdersDao.findQuestionOrderLimit50(appId, activityId), DuibaQuestionAnswerOrdersDto.class);
    }

    @Override
    public int updateLuckPrizeNone(DuibaQuestionAnswerOrdersDto order) {
        int ret = duibaQuestionAnswerOrdersDao.updateLuckPrizeNone(copy(order, DuibaQuestionAnswerOrdersEntity.class));
        cacheClient.remove(getCacheKeyById(order.getId()));
        return ret;
    }

    @Override
    public List<DeveloperActivityStatisticsDto> countFailByOperatingActivityIds(List<Long> ids) {
        return duibaQuestionAnswerOrdersDao.countFailByOperatingActivityIds(ids);
    }

    @Override
    public List<DuibaQuestionAnswerOrdersDto> findByLimit(Map<String, Object> queryMap) {
        return BeanUtils.copyList(duibaQuestionAnswerOrdersDao.findByLimit(queryMap),DuibaQuestionAnswerOrdersDto.class);
    }

    @Override
    public Long totalCount(Map<String, Object> queryMap) {
        return duibaQuestionAnswerOrdersDao.totalCount(queryMap);
    }

}
