package cn.com.duiba.activity.center.biz.service.hdtool.impl;

import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolOptionsDto;
import cn.com.duiba.activity.center.biz.dao.DsConstants;
import cn.com.duiba.activity.center.biz.dao.hdtool.DuibaHdtoolOptionsDao;
import cn.com.duiba.activity.center.biz.service.hdtool.DuibaHdtoolOptionsService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by wenqi.huang on 16/5/20.
 */
@Service
public class DuibaHdtoolOptionsServiceImpl implements DuibaHdtoolOptionsService {
    @Resource
    private DuibaHdtoolOptionsDao duibaHdtoolOptionsDao;

    @Override
    public List<DuibaHdtoolOptionsDto> findByHdtoolId(Long hdtoolId) {
        return BeanUtils.copyList(duibaHdtoolOptionsDao.findByHdtoolId(hdtoolId), DuibaHdtoolOptionsDto.class);
    }

    @Override
    public int addRemainingById(Long id, Integer addRemaining) {
        return duibaHdtoolOptionsDao.addRemainingById(id, addRemaining);
    }

    @Override
    public int subRemainingById(Long id, Integer subRemaining) {
        return duibaHdtoolOptionsDao.subRemainingById(id, subRemaining);
    }

    @Override
    public int updateRemainingById(Long id, Integer remaining) {
        return duibaHdtoolOptionsDao.updateRemainingById(id, remaining);
    }

    @Override
    @Transactional(value= DsConstants.DATABASE_CREDITS)
    public Integer findRemaingForupdate(Long id) {
        return duibaHdtoolOptionsDao.findRemaingForupdate(id);
    }
}
