package cn.com.duiba.activity.center.biz.service.ngame.impl;

import cn.com.duiba.activity.center.api.dto.ngame.DuibaNgameAppSpecifyDto;
import cn.com.duiba.activity.center.biz.dao.ngame.DuibaNgameAppSpecifyDao;
import cn.com.duiba.activity.center.biz.entity.ngame.DuibaNgameAppSpecifyEntity;
import cn.com.duiba.activity.center.biz.service.ngame.DuibaNgameAppSpecifyService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by wenqi.huang on 16/6/14.
 */
@Service
public class DuibaNgameAppSpecifyServiceImpl implements DuibaNgameAppSpecifyService {
    @Resource
    private DuibaNgameAppSpecifyDao duibaNgameAppSpecifyDao;

    public void add(DuibaNgameAppSpecifyDto gameAppSpecifyDO) {
        DuibaNgameAppSpecifyEntity e = BeanUtils.copy(gameAppSpecifyDO, DuibaNgameAppSpecifyEntity.class);
        duibaNgameAppSpecifyDao.add(e);
        gameAppSpecifyDO.setId(e.getId());
    }

    public void addBatch(List<DuibaNgameAppSpecifyDto> list) {
        List<DuibaNgameAppSpecifyEntity> eList = BeanUtils.copyList(list, DuibaNgameAppSpecifyEntity.class);
        duibaNgameAppSpecifyDao.addBatch(eList);
    }

    @Override
    public List<DuibaNgameAppSpecifyDto> findByGameId(Long id) {
        return BeanUtils.copyList(duibaNgameAppSpecifyDao.findByGameId(id), DuibaNgameAppSpecifyDto.class);
    }

    @Override
    public void delete(Long id) {
        duibaNgameAppSpecifyDao.delete(id);
    }

    @Override
    public DuibaNgameAppSpecifyDto findByGameConfigAndAppId(Long appId, Long duibaGameId) {
        return BeanUtils.copy(duibaNgameAppSpecifyDao.findByGameConfigAndAppId(appId, duibaGameId), DuibaNgameAppSpecifyDto.class);
    }

    @Override
    public Map<Long, DuibaNgameAppSpecifyDto> findByGameConfigsAndAppId(Long appId, List<Long> duibaGameIds) {
        List<DuibaNgameAppSpecifyEntity> list = duibaNgameAppSpecifyDao.findByGameConfigsAndAppId(appId, duibaGameIds);
        Map<Long, DuibaNgameAppSpecifyDto> map = new HashMap<>();
        for(DuibaNgameAppSpecifyEntity e : list){
            map.put(e.getDuibaGameId(), BeanUtils.copy(e, DuibaNgameAppSpecifyDto.class));
        }

        return map;
    }
}
