package cn.com.duiba.activity.center.biz.service.ngame.impl;

import cn.com.duiba.activity.center.api.dto.ngame.DuibaNgameOptionsDto;
import cn.com.duiba.activity.center.biz.dao.ngame.DuibaNgameOptionsDao;
import cn.com.duiba.activity.center.biz.entity.ngame.DuibaNgameOptionsEntity;
import cn.com.duiba.activity.center.biz.service.ngame.DuibaNgameOptionsService;
import cn.com.duiba.activity.center.biz.support.CacheConstants;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * Created by wenqi.huang on 16/6/15.
 */
@Service
public class DuibaNgameOptionsServiceImpl implements DuibaNgameOptionsService {
    @Resource
    private DuibaNgameOptionsDao duibaNgameOptionsDao;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyById(Long id){
        return CacheConstants.KEY_DUIBA_NGAMR_OPTIONS_BY_ID + id;
    }

    public void update(DuibaNgameOptionsDto duibaNgameOptionsDto) {
        duibaNgameOptionsDao.update(BeanUtils.copy(duibaNgameOptionsDto, DuibaNgameOptionsEntity.class));
        cacheClient.remove(getCacheKeyById(duibaNgameOptionsDto.getId()));
    }

    public void addBatch(List<DuibaNgameOptionsDto> list) {
        duibaNgameOptionsDao.addBatch(BeanUtils.copyList(list, DuibaNgameOptionsEntity.class));
    }

    public void add(DuibaNgameOptionsDto duibaNgameOptionsDto) {
        DuibaNgameOptionsEntity e = BeanUtils.copy(duibaNgameOptionsDto, DuibaNgameOptionsEntity.class);
        duibaNgameOptionsDao.add(e);
        duibaNgameOptionsDto.setId(e.getId());
    }

    @Override
    public List<DuibaNgameOptionsDto> findByGameId(Long duibaNgameId) {
        return BeanUtils.copyList(duibaNgameOptionsDao.findByGameId(duibaNgameId), DuibaNgameOptionsDto.class);
    }

    public Map<Long, List<DuibaNgameOptionsDto>> findByGameIds(List<Long> duibaNgameIds){
        List<DuibaNgameOptionsEntity> list = duibaNgameOptionsDao.findByGameIds(duibaNgameIds);
        Map<Long, List<DuibaNgameOptionsDto>> map = new HashMap<>();
        for(DuibaNgameOptionsEntity e : list){
            List<DuibaNgameOptionsDto> innerList = map.get(e.getDuibaGameId());
            if(innerList == null){
                innerList = new ArrayList<>();
                map.put(e.getDuibaGameId(), innerList);
            }
            innerList.add(BeanUtils.copy(e, DuibaNgameOptionsDto.class));
        }

        return map;
    }

    @Override
    public void delete(Long id) {
        duibaNgameOptionsDao.delete(id);
        cacheClient.remove(getCacheKeyById(id));
    }

    @Override
    public Integer countBigPrizeByGameId(Long duibaNgameId) {
        return duibaNgameOptionsDao.countBigPrizeByGameId(duibaNgameId);
    }

    @Override
    public DuibaNgameOptionsDto find(final Long id) {
        return cacheClient.getWithCacheLoader(getCacheKeyById(id), 20, TimeUnit.MINUTES, new CacheLoader<DuibaNgameOptionsDto>() {
            @Override
            public DuibaNgameOptionsDto load() {
                return BeanUtils.copy(duibaNgameOptionsDao.find(id), DuibaNgameOptionsDto.class);
            }
        });
    }

    @Override
    public List<DuibaNgameOptionsDto> findByAutoOpen(Long ngameId, boolean autoOpen) {
        return BeanUtils.copyList(duibaNgameOptionsDao.findByAutoOpen(ngameId, autoOpen), DuibaNgameOptionsDto.class);
    }

    @Override
    public List<DuibaNgameOptionsDto> findByAutoOpenDesc(Long ngameId, boolean autoOpen) {
        return BeanUtils.copyList(duibaNgameOptionsDao.findByAutoOpenDesc(ngameId, autoOpen), DuibaNgameOptionsDto.class);
    }

    @Override
    public List<DuibaNgameOptionsDto> findDisplayOption(Long ngameId) {
        return BeanUtils.copyList(duibaNgameOptionsDao.findDisplayOption(ngameId), DuibaNgameOptionsDto.class);
    }
}
