package cn.com.duiba.activity.center.biz.service.quizz.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzAppSpecifyDto;
import cn.com.duiba.activity.center.biz.dao.quizz.DuibaQuizzAppSpecifyDao;
import cn.com.duiba.activity.center.biz.entity.quizz.DuibaQuizzAppSpecifyEntity;
import cn.com.duiba.activity.center.biz.service.quizz.DuibaQuizzAppSpecifyService;
import cn.com.duiba.wolf.utils.BeanUtils;

import com.google.common.base.Preconditions;

/**
 * Created by wenqi.huang on 16/5/24.
 */
@Service
public class DuibaQuizzAppSpecifyServiceImpl implements DuibaQuizzAppSpecifyService {

    @Resource
    private DuibaQuizzAppSpecifyDao duibaQuizzAppSpecifyDao;

    @Override
    public List<DuibaQuizzAppSpecifyDto> findByDuibaQuizzId(Long duibaQuizzId) {

        List<DuibaQuizzAppSpecifyEntity> byDuibaQuizzId = duibaQuizzAppSpecifyDao.findByDuibaQuizzId(duibaQuizzId);
        if (CollectionUtils.isEmpty(byDuibaQuizzId)) {
            return Collections.emptyList();
        }

        return BeanUtils.copyList(byDuibaQuizzId, DuibaQuizzAppSpecifyDto.class);
    }

    @Override
    public void delete(Long id) {
        duibaQuizzAppSpecifyDao.delete(id);
    }

    @Override
    public void insert(DuibaQuizzAppSpecifyDto duibaQuizzAppSpecify) {
        Preconditions.checkNotNull(duibaQuizzAppSpecify, "duibaQuizzAppSpecify is null");
        DuibaQuizzAppSpecifyEntity copy = BeanUtils.copy(duibaQuizzAppSpecify, DuibaQuizzAppSpecifyEntity.class);
        duibaQuizzAppSpecifyDao.insert(copy);
        duibaQuizzAppSpecify.setId(copy.getId());
    }

    @Override
    public DuibaQuizzAppSpecifyDto findByDuibaQuizzAndApp(Long duibaQuizzId, Long appId) {
        return BeanUtils.copy(duibaQuizzAppSpecifyDao.findByDuibaQuizzAndApp(duibaQuizzId, appId),
                              DuibaQuizzAppSpecifyDto.class);
    }

    public Map<Long, DuibaQuizzAppSpecifyDto> findByDuibaQuizzsAndApp(List<Long> duibaQuizzIds, Long appId){
        List<DuibaQuizzAppSpecifyEntity> list = duibaQuizzAppSpecifyDao.findByDuibaQuizzsAndApp(duibaQuizzIds, appId);
        Map<Long, DuibaQuizzAppSpecifyDto> map = new HashMap<>();
        for(DuibaQuizzAppSpecifyEntity e : list){
            map.put(e.getDuibaQuizzId(), BeanUtils.copy(e, DuibaQuizzAppSpecifyDto.class));
        }

        return map;
    }

    @Override
    public DuibaQuizzAppSpecifyDto find(Long id) {
        return BeanUtils.copy(duibaQuizzAppSpecifyDao.find(id), DuibaQuizzAppSpecifyDto.class);
    }

    @Override
    public DuibaQuizzAppSpecifyDto findByQuizzIdAndAppId(Long quizzId, Long appId) {
        return BeanUtils.copy(duibaQuizzAppSpecifyDao.findByQuizzIdAndAppId(quizzId, appId),
                              DuibaQuizzAppSpecifyDto.class);
    }
}
