package cn.com.duiba.activity.center.biz.service.quizz.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import javax.annotation.Resource;

import cn.com.duiba.activity.center.biz.support.CacheConstants;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzBrickDto;
import cn.com.duiba.activity.center.biz.dao.quizz.DuibaQuizzBrickDao;
import cn.com.duiba.activity.center.biz.entity.quizz.DuibaQuizzBrickEntity;
import cn.com.duiba.activity.center.biz.service.quizz.DuibaQuizzBrickService;
import cn.com.duiba.wolf.utils.BeanUtils;

import com.google.common.base.Preconditions;

/**
 * Created by xuezhaoming on 16/6/8.
 */
@Service
public class DuibaQuizzBrickServiceImpl implements DuibaQuizzBrickService {

    @Resource
    private DuibaQuizzBrickDao duibaQuizzBrickDao;
	@Resource
	private CacheClient cacheClient;

	private String getNoContentCacheKeyById(Long id){
		return CacheConstants.KEY_DUIBA_QUIZZ_BRICK_NO_CONTENT_BY_ID + id;
	}

	private String getContentCacheKeyById(Long id){
		return CacheConstants.KEY_DUIBA_QUIZZ_BRICK_CONTENT_BY_ID + id;
	}

    @Override
    public DuibaQuizzBrickDto find(Long id) {
        Preconditions.checkNotNull(id, "id is null");
        return BeanUtils.copy(duibaQuizzBrickDao.find(id), DuibaQuizzBrickDto.class);
    }

    @Override
    public String getBrickContentById(final Long id) {

        Preconditions.checkNotNull(id, "id is null");
        return cacheClient.getWithCacheLoader(getContentCacheKeyById(id), 1, TimeUnit.HOURS, new CacheLoader<String>() {
			@Override
			public String load() {
				return duibaQuizzBrickDao.getBrickContentById(id);
			}
		});
    }

    @Override
    public DuibaQuizzBrickDto findNoContent(final Long id) {
        Preconditions.checkNotNull(id, "id is null");
		return cacheClient.getWithCacheLoader(getNoContentCacheKeyById(id), 1, TimeUnit.HOURS, new CacheLoader<DuibaQuizzBrickDto>() {
			@Override
			public DuibaQuizzBrickDto load() {
				return BeanUtils.copy(duibaQuizzBrickDao.findNoContent(id), DuibaQuizzBrickDto.class);
			}
		});
    }

	@Override
	public void insert(DuibaQuizzBrickDto duibaQuestionAnswerBrick) {
		DuibaQuizzBrickEntity entity = BeanUtils.copy(duibaQuestionAnswerBrick, DuibaQuizzBrickEntity.class);
		duibaQuizzBrickDao.insert(entity);
		duibaQuestionAnswerBrick.setId(entity.getId());
	}

	@Override
	public void update4Admin(Long id, String title, String content, String md5) {
		duibaQuizzBrickDao.update4Admin(id, title, content, md5);
		cacheClient.remove(getContentCacheKeyById(id));
		cacheClient.remove(getNoContentCacheKeyById(id));
	}

	@Override
	public DuibaQuizzBrickDto findByTitle(String title) {
		return BeanUtils.copy(duibaQuizzBrickDao.findByTitle(title), DuibaQuizzBrickDto.class);
	}

	@Override
	public void open(Long id) {
		duibaQuizzBrickDao.open(id);
		cacheClient.remove(getNoContentCacheKeyById(id));
	}

	@Override
	public void disable(Long id) {
		duibaQuizzBrickDao.disable(id);
		cacheClient.remove(getNoContentCacheKeyById(id));
	}

	@Override
	public List<DuibaQuizzBrickDto> findPage(Map<String, Object> queryMap) {
		return BeanUtils.copyList(duibaQuizzBrickDao.findPage(queryMap), DuibaQuizzBrickDto.class);
	}

	@Override
	public Long findPageCount() {
		return duibaQuizzBrickDao.findPageCount();
	}

	@Override
	public List<DuibaQuizzBrickDto> findAll() {
		return BeanUtils.copyList(duibaQuizzBrickDao.findAll(), DuibaQuizzBrickDto.class);
	}
}
