/**
 * Project Name:activity-center-biz
 * File Name:RemoteActivityCategoryBackendServiceImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.remoteservice.impl
 * Date:2016年6月7日上午8:55:59
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.remoteservice.impl;

import cn.com.duiba.activity.center.api.dto.ActivityCategoryDto;
import cn.com.duiba.activity.center.api.dto.CategoryActivityDto;
import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.remoteservice.RemoteActivityCategoryService;
import cn.com.duiba.activity.center.biz.entity.ActivityCategoryEntity;
import cn.com.duiba.activity.center.biz.entity.ActivityCategoryRelationEntity;
import cn.com.duiba.activity.center.biz.service.ActivityCategoryRelationService;
import cn.com.duiba.activity.center.biz.service.ActivityCategoryService;
import cn.com.duiba.activity.center.biz.service.activity.OperatingActivityService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * ClassName:RemoteActivityCategoryBackendServiceImpl <br/>
 * Date:	 2016年6月7日 上午8:55:59 <br/>
 * @author   xuhengfei
 * @version  
 * @since	JDK 1.6
 * @see 	 
 */
@Service("remoteActivityCategoryService")
public class RemoteActivityCategoryServiceImpl implements RemoteActivityCategoryService{
	
	private static final Logger log=LoggerFactory.getLogger(RemoteActivityCategoryServiceImpl.class);
	@Autowired
	private ActivityCategoryService activityCategoryService;
	@Autowired
	private ActivityCategoryRelationService activityCategoryRelationService;
	@Autowired
	private OperatingActivityService operatingActivityService;
	
	@Override
	public DubboResult<ActivityCategoryDto> findById(long id) {
		try{
			ActivityCategoryEntity endtity=activityCategoryService.findById(id);
			ActivityCategoryDto dto=new ActivityCategoryDto();
			dto.setId(endtity.getId());
			dto.setName(endtity.getName());
			dto.setEnable(endtity.getEnable());
			dto.setContent(endtity.getContent());
			return DubboResult.successResult(dto);
		}catch(Exception e){
			log.error("findAll",e);
			return DubboResult.failResult(e.getMessage());
		}
	}
	
	@Override
	public DubboResult<List<CategoryActivityDto>> findAllActivitiesByAppCategory(long appId, long categoryId,int start,int pageSize) {
		try {
			// find all by appId,categoryId
			List<ActivityCategoryRelationEntity> acrs = this.activityCategoryRelationService.findByAppCategory(appId,categoryId,start,pageSize);
			List<CategoryActivityDto> dtos = new ArrayList<CategoryActivityDto>();

			if (acrs != null && acrs.size() > 0) {
				for (ActivityCategoryRelationEntity acr : acrs) {
					
					CategoryActivityDto dto = new CategoryActivityDto();
					dto.setId(acr.getId());
					dto.setOperatingId(acr.getOperatingActivityId());
					dto.setPayload(acr.getPayload());
					dto.setAppId(appId);
					dto.setCategoryId(categoryId);
					dtos.add(dto);
				}
			}
			return DubboResult.successResult(dtos);
		} catch (Exception e) {
			log.error("findAllActivitiesByAppCategory error,appId="+appId+",categoryId="+categoryId , e);
			return DubboResult.failResult(e.getMessage());
		}
	}
}
