package cn.com.duiba.activity.center.biz.remoteservice.impl.hdtool;

import cn.com.duiba.activity.center.api.dto.DeveloperActivityStatisticsDto;
import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolOrdersDto;
import cn.com.duiba.activity.center.api.remoteservice.hdtool.RemoteAppHdtoolOrdersService;
import cn.com.duiba.activity.center.biz.service.hdtool.AppHdtoolOrdersService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * hdtool_orders表的app维度分表,活动工具订单业务DAO
 */
@Service
public class RemoteAppHdtoolOrdersServiceImpl implements RemoteAppHdtoolOrdersService {
	@Resource
	private AppHdtoolOrdersService appHdtoolOrdersService;

	@Override
	public HdtoolOrdersDto find(Long appId, Long id) {
		return appHdtoolOrdersService.find(appId, id);
	}

	@Override
	public HdtoolOrdersDto findByAppAndDeveloperBizId(Long appId, String bizId) {
		return appHdtoolOrdersService.findByAppAndDeveloperBizId(appId, bizId);
	}

	@Override
	public List<DeveloperActivityStatisticsDto> countFailByOperatingActivityIds(Long appId, List<Long> ids) {
		return appHdtoolOrdersService.countFailByOperatingActivityIds(appId, ids);
	}

	@Override
	public List<HdtoolOrdersDto> findByLimit(Map<String, Object> queryParam) {
		return appHdtoolOrdersService.findByLimit(queryParam);
	}

	@Override
	public Long totalCount(Map<String, Object> queryParam) {
		return appHdtoolOrdersService.totalCount(queryParam);
	}

	@Override
	public List<HdtoolOrdersDto> findByIds(Long appId, List<Long> ids) {
		return appHdtoolOrdersService.findByIds(appId, ids);
	}

	@Override
	public List<HdtoolOrdersDto> findHdtoolOrderLimit50(Long appId, Long activityId) {
		return appHdtoolOrdersService.findHdtoolOrderLimit50(appId, activityId);
	}

}
