package cn.com.duiba.activity.center.biz.remoteservice.impl.quizz;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzOptionsDto;
import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzStockDto;
import cn.com.duiba.activity.center.api.remoteservice.quizz.RemoteDuibaQuizzOptionsService;
import cn.com.duiba.activity.center.biz.service.quizz.DuibaQuizzOptionsService;
import cn.com.duiba.activity.center.biz.service.quizz.QuizzStockService;

/**
 * Created by xuezhaoming on 16/6/15.
 */
@Service
public class RemoteDuibaQuizzOptionsServiceImpl implements RemoteDuibaQuizzOptionsService {

    @Resource
    private DuibaQuizzOptionsService quizzOptionsService;

    @Resource
    private QuizzStockService   quizzStockService;

    @Override
    public List<DuibaQuizzOptionsDto> findOptionsByQuizzId(Long duibaQuizzId) {
        return quizzOptionsService.findOptionsByQuizzId(duibaQuizzId);
    }

    @Override
    public DuibaQuizzOptionsDto find(Long id) {
        return quizzOptionsService.find(id);
    }

    // from manager
    @Override
    public List<DuibaQuizzOptionsDto> findByQuizzId(Long quizzId) {
        List<DuibaQuizzOptionsDto> optionList = quizzOptionsService.findOptionsByQuizzId(quizzId);
        List<Long> optionIds = new ArrayList<Long>();
        for (int i = 0; i < optionList.size(); i++) {
            optionIds.add(optionList.get(i).getId());
        }
        if (!optionIds.isEmpty()) {
            List<DuibaQuizzStockDto> stocks = quizzStockService.findByQuizzOptionIds(optionIds);
            Map<Long, DuibaQuizzStockDto> stockMap = new HashMap<Long, DuibaQuizzStockDto>();
            for (int i = 0; i < stocks.size(); i++) {
                stockMap.put(stocks.get(i).getQuizzOptionId(), stocks.get(i));
            }
            for (int i = 0; i < optionList.size(); i++) {
                DuibaQuizzOptionsDto optionDo = optionList.get(i);
                DuibaQuizzStockDto duibaQuizzStockDO = stockMap.get(optionDo.getId());
                if (null != duibaQuizzStockDO) {
                    optionDo.setOptionCount(duibaQuizzStockDO.getStock());
                }
            }
        }
        return optionList;
    }

    public Map<Long, List<DuibaQuizzOptionsDto>> findByQuizzIds(List<Long> quizzIds){
        return quizzOptionsService.findByQuizzIds(quizzIds);
    }

    @Override
    public int delete(List<Long> ids) {
        return quizzOptionsService.delete(ids);
    }

    @Override
    public DuibaQuizzOptionsDto insert(DuibaQuizzOptionsDto quizzOptionsDO) {
        quizzOptionsService.insert(quizzOptionsDO);
        return quizzOptionsDO;
    }

    @Override
    public int updateInfoForm(DuibaQuizzOptionsDto quizzOptionsDO) {
        return quizzOptionsService.updateInfoForm(quizzOptionsDO);
    }

    @Override
    public int updateRemainingById(Long id, Integer remaining) {
        return quizzOptionsService.updateRemainingById(id, remaining);
    }
}
