package cn.com.duiba.activity.center.biz.service.hdtool.impl;

import cn.com.duiba.activity.center.api.dto.ActivityExtraInfoDto;
import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolDto;
import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolOptionsDto;
import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolAppSpecifyDto;
import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.activity.center.biz.dao.DsConstants;
import cn.com.duiba.activity.center.biz.dao.hdtool.DuibaHdtoolDao;
import cn.com.duiba.activity.center.biz.entity.hdtool.DuibaHdtoolEntity;
import cn.com.duiba.activity.center.biz.entity.hdtool.DuibaHdtoolOptionsEntity;
import cn.com.duiba.activity.center.biz.entity.hdtool.HdtoolAppSpecifyEntity;
import cn.com.duiba.activity.center.biz.service.hdtool.DuibaHdtoolService;
import cn.com.duiba.activity.center.biz.support.CacheConstants;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * Created by wenqi.huang on 16/5/19.
 */
@Service
public class DuibaHdtoolServiceImpl implements DuibaHdtoolService {
    @Resource
    private DuibaHdtoolDao duibaHdtoolDao;
    @Resource
    private CacheClient cacheClient;

    private String getDuibaHdtoolCacheKeyById(Long id){
        return CacheConstants.KEY_DUIBA_HDTOOL_BY_ID + id;
    }

    @Override
    public List<DuibaHdtoolDto> findAutoOff() {
        return BeanUtils.copyList(duibaHdtoolDao.findAutoOff(), DuibaHdtoolDto.class);
    }

    @Override
    public DuibaHdtoolDto find(final Long id) {
        return cacheClient.getWithCacheLoader(getDuibaHdtoolCacheKeyById(id), 5, TimeUnit.MINUTES, new CacheLoader<DuibaHdtoolDto>() {
            @Override
            public DuibaHdtoolDto load() {
                return BeanUtils.copy(duibaHdtoolDao.find(id), DuibaHdtoolDto.class);
            }
        });
    }

    @Override
    public List<DuibaHdtoolDto> findDuibaHdToolsList(Map<String, Object> paramMap) {
        return BeanUtils.copyList(duibaHdtoolDao.findDuibaHdToolsList(paramMap), DuibaHdtoolDto.class);
    }

    @Override
    public Integer countDuibaHdToolsList(Map<String, Object> queryMap) {
        return duibaHdtoolDao.countDuibaHdToolsList(queryMap);
    }

    @Override
    public List<AddActivityDto> findAllDuibaHdTools(Long appId) {
        return BeanUtils.copyList(duibaHdtoolDao.findAllDuibaHdTools(appId), AddActivityDto.class);
    }

    @Override
    public List<DuibaHdtoolDto> findAllByIds(List<Long> ids) {
        return BeanUtils.copyList(duibaHdtoolDao.findAllByIds(ids), DuibaHdtoolDto.class);
    }

    @Override
    public List<HdtoolAppSpecifyDto> findAllSpecifyByHdToolId(Long hdToolId) {
        return BeanUtils.copyList(duibaHdtoolDao.findAllSpecifyByHdToolId(hdToolId), HdtoolAppSpecifyDto.class);
    }

    @Override
    public HdtoolAppSpecifyDto findSpecifyByHdToolIdAndApp(Long duibaHdToolId, Long appId) {
        return BeanUtils.copy(duibaHdtoolDao.findSpecifyByHdToolIdAndApp(duibaHdToolId, appId), HdtoolAppSpecifyDto.class);
    }

    public Map<Long, HdtoolAppSpecifyDto> findSpecifyByHdToolIdsAndApp(List<Long> duibaHdToolIds, Long appId){
        List<HdtoolAppSpecifyEntity> list = duibaHdtoolDao.findSpecifyByHdToolIdsAndApp(duibaHdToolIds, appId);
        Map<Long, HdtoolAppSpecifyDto> map = new HashMap<>();
        for(HdtoolAppSpecifyEntity e : list){
            map.put(e.getDuibaHdtoolId(), BeanUtils.copy(e, HdtoolAppSpecifyDto.class));
        }

        return map;
    }

    @Override
    public HdtoolAppSpecifyDto findSpecifyById(Long id) {
        return BeanUtils.copy(duibaHdtoolDao.findSpecifyById(id), HdtoolAppSpecifyDto.class);
    }

    @Override
    public ActivityExtraInfoDto findExtraInfoById(Long id) {
        return BeanUtils.copy(duibaHdtoolDao.findExtraInfoById(id), ActivityExtraInfoDto.class);
    }

    @Override
    public Long getCountDuibaHdTool(Map<String, Object> queryMap) {
        return duibaHdtoolDao.getCountDuibaHdTool(queryMap);
    }

    @Override
    public List<DuibaHdtoolDto> findDuibaToolList(Map<String, Object> queryMap) {
        return BeanUtils.copyList(duibaHdtoolDao.findDuibaToolList(queryMap), DuibaHdtoolDto.class);
    }

    @Override
    public int updateAutoOffDateNull(Long id) {
        int ret = duibaHdtoolDao.updateAutoOffDateNull(id);
        cacheClient.remove(getDuibaHdtoolCacheKeyById(id));
        return ret;
    }

    @Override
    public void insert(DuibaHdtoolDto duibaHdtoolDto) {
        DuibaHdtoolEntity e = BeanUtils.copy(duibaHdtoolDto, DuibaHdtoolEntity.class);
        duibaHdtoolDao.insert(e);
        duibaHdtoolDto.setId(e.getId());
    }

    @Override
    public int deleteById(Long id) {
        int ret = duibaHdtoolDao.deleteById(id);
        cacheClient.remove(getDuibaHdtoolCacheKeyById(id));
        return ret;
    }

    @Override
    public int update(DuibaHdtoolDto duibaHdtoolDto) {
        int ret = duibaHdtoolDao.update(BeanUtils.copy(duibaHdtoolDto, DuibaHdtoolEntity.class));
        cacheClient.remove(getDuibaHdtoolCacheKeyById(duibaHdtoolDto.getId()));
        return ret;
    }

    @Override
    public int updateStatus(Long id, Integer status) {
        int ret = duibaHdtoolDao.updateStatus(id, status);
        cacheClient.remove(getDuibaHdtoolCacheKeyById(id));
        return ret;
    }

    @Override
    public int deleteSpecifyById(Long id) {
        return duibaHdtoolDao.deleteSpecifyById(id);
    }

    @Override
    public void insertSpecify(HdtoolAppSpecifyDto hdtoolAppSpecifyDO) {
        HdtoolAppSpecifyEntity e = BeanUtils.copy(hdtoolAppSpecifyDO, HdtoolAppSpecifyEntity.class);
        duibaHdtoolDao.insertSpecify(e);
        hdtoolAppSpecifyDO.setId(e.getId());
    }

    @Override
	public int updateActivityCategory(long  duibaHdtoolId,long activityCategoryId){
    	int ret = duibaHdtoolDao.updateActivityCategory(duibaHdtoolId, activityCategoryId);
        cacheClient.remove(getDuibaHdtoolCacheKeyById(duibaHdtoolId));
        return ret;
    }
    
	/**
     * 根据ID查询标签
     */
    @Override
    public String findTag(Long id){
    	return duibaHdtoolDao.findTag(id);
    }
}
