/**
 * Project Name:activity-center-biz
 * File Name:TodayRobConfigServiceImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.service.rob.impl
 * Date:2016年7月26日下午2:26:44
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.service.rob.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import sun.misc.Compare;

import com.google.common.collect.Lists;

import cn.com.duiba.activity.center.api.dto.rob.TodayRobConfigDto;
import cn.com.duiba.activity.center.biz.dao.rob.TodayRobConfigDao;
import cn.com.duiba.activity.center.biz.service.rob.TodayRobConfigService;

/**
 * ClassName:TodayRobConfigServiceImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年7月26日 下午2:26:44 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class TodayRobConfigServiceImpl implements TodayRobConfigService{
    
    @Autowired
    private TodayRobConfigDao todayRobConfigDao;

    @Override
    public TodayRobConfigDto find(Long configId) {
        return todayRobConfigDao.find(configId);
    }

    @Override
    public Long saveOrUpdateTodayRobConfig(TodayRobConfigDto todayRobConfigDto) {
        if(todayRobConfigDto.getId() != null){
           todayRobConfigDao.update(todayRobConfigDto);
           return todayRobConfigDto.getId();
        }
        return (long)todayRobConfigDao.insert(todayRobConfigDto);
    }

    @Override
    public List<TodayRobConfigDto> findTodayRobConfigPage(Map<String, Object> params) {
        return todayRobConfigDao.findTodayRobConfigPage(params);
    }

    @Override
    public Integer findTodayRobConfigCount(Map<String, Object> params) {
        return todayRobConfigDao.findTodayRobConfigCount(params);
    }

    @Override
    public Boolean delTodayRobConfig(Long configId) {
        return todayRobConfigDao.del(configId);
    }

    @Override
    public Boolean statusChange(Long configId, Integer status) {
        return todayRobConfigDao.statusChange(configId, status);
    }

    @Override
    public List<TodayRobConfigDto> findSortTodayRobConfig(Integer offset, Integer pageSize) {
        List<TodayRobConfigDto> robs = todayRobConfigDao.findSortTodayRobConfig(offset, pageSize);
        List<TodayRobConfigDto> robAllDtos = Lists.newLinkedList();
        List<TodayRobConfigDto> robTopDtos = Lists.newArrayList();
        List<TodayRobConfigDto> robDtos = Lists.newArrayList();
        for(TodayRobConfigDto rob : robs){
            if(rob.isOpenSwitch(TodayRobConfigDto.SWITCHES_TOP)){
                robTopDtos.add(rob);
            }else{
                robDtos.add(rob);
            }
        }
        Collections.sort(robTopDtos, new Comparator<TodayRobConfigDto>(){
            @Override
            public int compare(TodayRobConfigDto o1, TodayRobConfigDto o2) {
                if(o1.getStickyTime().before(o2.getStickyTime())){
                    return 1;
                }else{
                    return -1;
                }
            }
        });
        Collections.sort(robDtos, new Comparator<TodayRobConfigDto>(){
            @Override
            public int compare(TodayRobConfigDto o1, TodayRobConfigDto o2) {
                if(o1.getGmtCreate().before(o2.getGmtCreate())){
                    return 1;
                }else{
                    return -1;
                }
            }
        });
        robAllDtos.addAll(robTopDtos);
        robAllDtos.addAll(robDtos);
        return robAllDtos;
    }

    @Override
    public Boolean updateStickyTime(Long id, Integer switches, Date stickyTime) {
        return todayRobConfigDao.updateStickyTime(id, switches, stickyTime);
    }

    @Override
    public Boolean updateVisitTime(Long id) {
        return todayRobConfigDao.updateVisitTime(id);
    }

}

