package cn.com.duiba.activity.center.biz.service.seconds_kill.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.activity.center.api.dto.seconds_kill.DuibaSecondsKillActivityDto;
import cn.com.duiba.activity.center.biz.dao.seconds_kill.DuibaSecondsKillActivityDao;
import cn.com.duiba.activity.center.biz.entity.seconds_kill.DuibaSecondsKillActivityEntity;
import cn.com.duiba.activity.center.biz.service.seconds_kill.DuibaSecondsKillActivityService;
import cn.com.duiba.activity.center.biz.support.CacheConstants;
import cn.com.duiba.activity.center.biz.support.copier.manual.AppManualLotteryCopier;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * Created by xuezhaoming on 16/6/12.
 */
@Service
public class DuibaSecondsKillActivityServiceImpl implements DuibaSecondsKillActivityService {

	@Resource
    private DuibaSecondsKillActivityDao duibaSecondsKillActivityDao;
	
	@Autowired
	private CacheClient         cacheClient;
	
	private int cacheTime = 300; //5分钟时间
	
	private String getCacheKeyById(Long id) {
        return CacheConstants.KEY_DUIBA_SECONDS_KILL_ACTIVITY_BY_ID + id;
    }

    @Override
    public DuibaSecondsKillActivityDto find(Long id) {
    	String key = getCacheKeyById(id);
    	DuibaSecondsKillActivityDto d = cacheClient.get(key);
    	if (d == null) {
    		DuibaSecondsKillActivityEntity entity = duibaSecondsKillActivityDao.find(id);
    		if (entity == null) {
                return null;
            }

            d = BeanUtils.copy(entity, DuibaSecondsKillActivityDto.class);
            cacheClient.set(key, d, cacheTime);
    	}
    	return d;
    }
    
    @Override
    public String findTagById(Long id) {
        return duibaSecondsKillActivityDao.findTagById(id);
    }

    @Override
    public List<AddActivityDto> findAllDuibaSecondKillByAppId(Long appId) {
        return BeanUtils.copyList(duibaSecondsKillActivityDao.findAllDuibaSecondKillByAppId(appId), AddActivityDto.class);
    }

    @Override
    public List<DuibaSecondsKillActivityDto> findAllByIds(List<Long> ids) {
        return BeanUtils.copyList(duibaSecondsKillActivityDao.findAllByIds(ids), DuibaSecondsKillActivityDto.class);
    }

    @Override
    public List<DuibaSecondsKillActivityDto> findAutoOff() {
        return BeanUtils.copyList(duibaSecondsKillActivityDao.findAutoOff(), DuibaSecondsKillActivityDto.class);
    }
    
    @Override
    public int updateTagById(Long id, String tag) {
        int ret = duibaSecondsKillActivityDao.updateTagById(id, tag);
        cacheClient.remove(getCacheKeyById(id));
        return ret;
    }

    @Override
    public void changeStatus(Long id, Integer status) {
        duibaSecondsKillActivityDao.changeStatus(id, status);
        cacheClient.remove(getCacheKeyById(id));
    }

    @Override
    public int updateAutoOffDateNull(Long id) {
        int num = duibaSecondsKillActivityDao.updateAutoOffDateNull(id);
        cacheClient.remove(getCacheKeyById(id));
        return num;
    }

    @Override
    public void insert(DuibaSecondsKillActivityDto DuibaSecondsKillActivityDto) {
    	DuibaSecondsKillActivityEntity entity = BeanUtils.copy(DuibaSecondsKillActivityDto, DuibaSecondsKillActivityEntity.class);
        duibaSecondsKillActivityDao.insert(entity);
    	DuibaSecondsKillActivityDto.setId(entity.getId());
    }

    @Override
    public List<DuibaSecondsKillActivityDto> findByPage(Map<String, Object> params) {
        return BeanUtils.copyList(duibaSecondsKillActivityDao.findByPage(params), DuibaSecondsKillActivityDto.class);
    }

    @Override
    public int count() {
        return duibaSecondsKillActivityDao.count();
    }

    @Override
    public int count(Map<String, Object> params) {
        return duibaSecondsKillActivityDao.count(params);
    }

    @Override
    public void deleteById(Long id) {
        duibaSecondsKillActivityDao.deleteById(id);
        cacheClient.remove(getCacheKeyById(id));
    }

    @Override
    public void updateSwitches(Long id, Long switches) {
        duibaSecondsKillActivityDao.updateSwitches(id, switches);
        cacheClient.remove(getCacheKeyById(id));
    }

    @Override
    public void update(DuibaSecondsKillActivityDto DuibaSecondsKillActivityDto) {
        duibaSecondsKillActivityDao.update(BeanUtils.copy(DuibaSecondsKillActivityDto, DuibaSecondsKillActivityEntity.class));
        cacheClient.remove(getCacheKeyById(DuibaSecondsKillActivityDto.getId()));
    }
}
