package cn.com.duiba.activity.center.biz.tools.service;
import net.rubyeye.xmemcached.GetsResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.biz.tools.XMemCacheClient;
import cn.com.duiba.activity.center.common.util.DateUtil;

/**
 * 今日活动统计（只做估算，可能不准）
 */
@Service
public class TodayActivityStatisticsService {

	private static Logger log = LoggerFactory.getLogger(TodayActivityStatisticsService.class);

	private final String OPERATING_ACTIVITY = "activity_";
	
	@Autowired @Qualifier("memCacheClient")
    private XMemCacheClient xMemCacheClient;

	/**
	 * 添加今日消耗积分
	 */
	public void addTodayConsumeCredits(Long activityId,String activityType,Long appId,Long credits) {
		if (credits != null && activityId != null) {
			try {
				String creditsKey = OPERATING_ACTIVITY + activityId 
				        + "_" + activityType + "_" + appId + "_credits";
				if (setByCas(creditsKey, credits.intValue(), 1) == 2) {
				    xMemCacheClient.getMemcachedClient().set(creditsKey, DateUtil.getToTomorrowSeconds(), credits.intValue());
				}
			} catch (Exception e) {
				log.error("添加消耗积分异常", e);
			}
		}
	}

	/**
	 * 回滚今日消耗积分
	 */
	public void rollbackTodayConsumeCredits(Long activityid,String activityType,Long appId,Long credits) {
		if (credits != null && activityid != null) {
			try {
				String creditsKey = OPERATING_ACTIVITY + activityid
				        + "_" + activityType + "_" + appId + "_credits";
				setByCas(creditsKey, credits.intValue(), -1);
			} catch (Exception e) {
				log.error("回滚消耗积分异常", e);
			}
		}
	}

	/**
	 * 中奖后，当日中奖人次增加
	 */
	public void addTodayWinCount(Long ativityId,String activityType,Long appId) {
		if (ativityId != null) {
			try {
				String winCountKey = OPERATING_ACTIVITY + ativityId
				        + "_" + activityType + "_" + appId + "_winCount";
				if (setByCas(winCountKey, 1, 1) == 2) {
				    xMemCacheClient.getMemcachedClient().add(winCountKey, DateUtil.getToTomorrowSeconds(), 1);
				}
			} catch (Exception e) {
				log.error("添加当日中奖人次异常", e);
			}
		}
	}

	private Integer setByCas(final String key, final int value, final int type) {
		Integer result = null;
		boolean loop = true;
		try {
			int loopNum = 0;
			while (loop) {
				if (loopNum >= 10) {
					loop = false;
					result = 1;// 系统繁忙
					break;
				}
				GetsResponse<Object> last = xMemCacheClient.getMemcachedClient().gets(key);
				if (last == null) {
					loop = false;
					result = 2;// 缓存对象为空
					break;
				} else {
					int nextValue = (Integer) last.getValue();
					if (type > 0) {
						nextValue = nextValue + value;
					} else if (type < 0) {
						if (nextValue >= value) {
							nextValue = nextValue - value;
						} else {
							nextValue = 0;
						}
					} else {
						loop = false;
						result = 4;// 参数错误
						break;
					}
					boolean bo = xMemCacheClient.getMemcachedClient().cas(key,DateUtil.getToTomorrowSeconds(),nextValue,last.getCas());
					if(bo){
					    loop = false;
                        result = 0; // 更新成功
                        break;
					}
				}
				loopNum++;
			}
		} catch (Exception e) {
			result = 5;
			log.error("更新缓存异常:", e);
		}
		return result;
	}
}
