/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.plugin.event.credits.impl;

import cn.com.duiba.activity.center.biz.constant.Environment;
import cn.com.duiba.activity.center.biz.exception.DeveloperConsumeFailedException;
import cn.com.duiba.activity.center.biz.plugin.event.credits.ConsumeCreditsFailEvent;
import cn.com.duiba.activity.center.biz.pool.ThreadPoolDuibaService;
import cn.com.duiba.activity.center.biz.tools.service.SmsRemindService;
import cn.com.duiba.activity.center.common.util.DateUtil;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.AppExceptionLogDO;
import cn.com.duiba.service.domain.dataobject.AppExtraDO;
import cn.com.duiba.service.domain.dataobject.DeveloperDO;
import cn.com.duiba.service.remoteservice.RemoteAppExceptionLogService;
import cn.com.duiba.service.remoteservice.RemoteAppExtraService;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.service.remoteservice.RemoteDeveloperService;
import cn.com.duiba.wolf.cache.CacheClient;
import java.text.NumberFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityConsumerCreditsFailImpl
implements ConsumeCreditsFailEvent.ConsumeCreditsFailListener,
InitializingBean {
    private static Logger log = LoggerFactory.getLogger(ActivityConsumerCreditsFailImpl.class);
    @Autowired
    private CacheClient memcachedClient;
    @Autowired
    private RemoteAppService remoteAppService;
    @Autowired
    private SmsRemindService smsRemindService;
    @Autowired
    private RemoteAppExtraService remoteAppExtraService;
    @Autowired
    private RemoteDeveloperService remoteDeveloperService;
    @Autowired
    private RemoteActivityOrderService remoteActivityOrderService;
    @Autowired
    private RemoteAppExceptionLogService remoteAppExceptionLogService;

    private String getKey(Long appId) {
        return "106-" + appId;
    }

    private String getFailPercentRate(Integer failNum, Integer successNum) {
        NumberFormat format = NumberFormat.getPercentInstance();
        format.setMinimumFractionDigits(2);
        return format.format(Double.parseDouble(failNum + "") / Double.parseDouble(successNum + failNum + ""));
    }

    private boolean checkMobileNumber(String mobileNumber) {
        boolean flag = false;
        try {
            Pattern regex = Pattern.compile("^[0-9]{11}$");
            Matcher matcher = regex.matcher(mobileNumber);
            flag = matcher.matches();
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    private synchronized void checkAlarm(final Long appId, final Integer value, final Integer success) {
        if (value == 10 || value == 50 || value == 100 || value == 500 || value == 1000) {
            ThreadPoolDuibaService.get().submit(new Runnable(){

                @Override
                public void run() {
                    DeveloperDO developer;
                    AppExtraDO appExtra;
                    String text;
                    AppDO app = ActivityConsumerCreditsFailImpl.this.remoteAppService.find(appId);
                    String list = Environment.getConsumeFailAlarmList();
                    if (list != null) {
                        String[] phones;
                        for (String p : phones = list.split(",")) {
                            try {
                                String rate = ActivityConsumerCreditsFailImpl.this.getFailPercentRate(value, success);
                                text = "App " + app.getName() + "(" + appId + ")\u4eca\u65e5\u6263\u79ef\u5206\u8bf7\u6c42\u5931\u8d25\u6b21\u6570\u8fbe\u5230" + value + "\u6b21(\u5171\u8ba1" + (value + success) + "\u6b21,\u5931\u8d25\u7387=" + rate + ")\uff0c\u8bf7\u786e\u8ba4\u7cfb\u7edf\u662f\u5426\u6709\u5f02\u5e38\u60c5\u51b5";
                                if (Double.parseDouble(rate.substring(0, rate.indexOf("%"))) > 1.0) {
                                    ActivityConsumerCreditsFailImpl.this.smsRemindService.sendCreditsAlarmSms(p, app.getName(), value, success);
                                }
                                log.error(text);
                            }
                            catch (Exception e) {
                                log.error("checkAlarm error", (Throwable)e);
                            }
                        }
                    }
                    if ((appExtra = ActivityConsumerCreditsFailImpl.this.remoteAppExtraService.findByAppId(appId)) != null && appExtra.getAlarmPhone() != null) {
                        String[] phones;
                        for (String p : phones = appExtra.getAlarmPhone().split(",")) {
                            if (ActivityConsumerCreditsFailImpl.this.checkMobileNumber(p)) {
                                try {
                                    text = "App " + app.getName() + "(" + appId + "),\u4eca\u65e5\u5f02\u5e38\u8ba2\u5355\u6570\u989d\u5df2\u8fbe" + value + "\u6761\uff0c\u8bf7\u786e\u8ba4\u7cfb\u7edf\u662f\u5426\u6709\u5f02\u5e38\u60c5\u51b5";
                                    ActivityConsumerCreditsFailImpl.this.smsRemindService.sendDevExceptionAlarmSms(p, app.getName(), value);
                                    log.error(text);
                                }
                                catch (Exception e) {
                                    log.error("checkDevExceptionAlarm error", (Throwable)e);
                                }
                                continue;
                            }
                            log.error(app.getName() + ":" + p + "\uff0c\u53f7\u7801\u9519\u8bef\uff0c\u77ed\u4fe1\u901a\u77e5\u5931\u8d25");
                        }
                    } else if (app != null && app.getDeveloperId() != null && (developer = ActivityConsumerCreditsFailImpl.this.remoteDeveloperService.find(app.getDeveloperId())) != null && developer.getPhone() != null) {
                        if (ActivityConsumerCreditsFailImpl.this.checkMobileNumber(developer.getPhone())) {
                            try {
                                String text2 = "App " + app.getName() + "(" + appId + "),\u4eca\u65e5\u5f02\u5e38\u8ba2\u5355\u6570\u989d\u5df2\u8fbe" + value + "\u6761\uff0c\u8bf7\u786e\u8ba4\u7cfb\u7edf\u662f\u5426\u6709\u5f02\u5e38\u60c5\u51b5";
                                ActivityConsumerCreditsFailImpl.this.smsRemindService.sendDevExceptionAlarmSms(developer.getPhone(), app.getName(), value);
                                log.error(text2);
                            }
                            catch (Exception e) {
                                log.error("checkDevExceptionAlarm error", (Throwable)e);
                            }
                        } else {
                            log.error(app.getName() + ":" + developer.getPhone() + "\uff0c\u53f7\u7801\u9519\u8bef\uff0c\u77ed\u4fe1\u901a\u77e5\u5931\u8d25");
                        }
                    }
                }
            }, 1);
        }
    }

    public void afterPropertiesSet() throws Exception {
    }

    private synchronized void plus(Long appId) {
        Integer value = (Integer)this.memcachedClient.get(this.getKey(appId));
        if (value == null) {
            value = 1;
            this.memcachedClient.set(this.getKey(appId), (Object)DateUtil.getToTomorrowSeconds(), value.intValue());
        } else {
            Integer n = value;
            Integer n2 = value = Integer.valueOf(value + 1);
            this.memcachedClient.set(this.getKey(appId), (Object)DateUtil.getToTomorrowSeconds(), value.intValue());
        }
        Integer success = 0;
        Object suc = this.memcachedClient.get("119-" + appId);
        if (null != suc) {
            success = (Integer)suc;
        }
        this.checkAlarm(appId, value, success);
    }

    private void process(Long appId, String orderNum, String type, Exception e) {
        if (e instanceof DeveloperConsumeFailedException) {
            DeveloperConsumeFailedException dc = (DeveloperConsumeFailedException)e;
            if (!dc.getNormalFail().booleanValue()) {
                this.plus(appId);
            }
            if (dc.getFailType() != null) {
                AppExceptionLogDO exceptionLog = new AppExceptionLogDO(true);
                if (type.equals("rob")) {
                    ActivityOrderDto order = (ActivityOrderDto)this.remoteActivityOrderService.findByOrderNum(orderNum).getResult();
                    exceptionLog.setAppId(order.getAppId());
                    exceptionLog.setRelationId(Long.valueOf(order.getOrderNum()));
                    exceptionLog.setConsumerId(order.getConsumerId());
                    exceptionLog.setOrderNum("activity-" + order.getOrderNum());
                    exceptionLog.setRelationType(Integer.valueOf(1));
                }
                exceptionLog.setErrorMessage(dc.getMessage());
                exceptionLog.setUrl(dc.getUrl());
                exceptionLog.setRespone(dc.getDevRespone());
                exceptionLog.setDevExceptionType(dc.getFailType());
                exceptionLog.setInterfaceType(dc.getInterfaceType());
                this.remoteAppExceptionLogService.insert(exceptionLog);
            }
        } else {
            this.plus(appId);
        }
    }

    @Override
    public void onConsumeActivityOrderFail(ActivityOrderDto order, Exception e) {
        this.process(order.getAppId(), order.getOrderNum(), order.getActivityType(), e);
    }
}

