/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.plugin.event.order.impl;

import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsRegister;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent;
import cn.com.duiba.activity.center.biz.tools.RedisClientTool;
import cn.com.duiba.activity.center.biz.tools.service.AppTradingLimitService;
import cn.com.duiba.activity.center.biz.tools.service.TodayActivityStatisticsService;
import cn.com.duiba.activity.center.biz.tools.service.TodayCountService;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityOrderPluginImpl
implements InitializingBean {
    @Autowired
    private AppTradingLimitService appTradingLimit;
    @Autowired
    private TodayCountService todayCountService;
    @Autowired
    private TodayActivityStatisticsService todayActivityStatisticsService;
    @Autowired
    private RedisClientTool redisClientTool;

    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().registActivityOrdersEvent(new ActivityOrdersEvent.ActivityOrdersEventListener(){

            @Override
            public void onOrderSuccess(ActivityOrderDto order) {
                ActivityOrderPluginImpl.this.appTradingLimit.addTrading(order.getAppId());
                ActivityOrderPluginImpl.this.todayCountService.addExpectByCredits(order.getAppId(), order.getConsumeCredits());
                ActivityOrderPluginImpl.this.todayActivityStatisticsService.addTodayWinCount(order.getDuibaActivityId(), order.getActivityType(), order.getAppId());
            }

            @Override
            public void onOrderFail(ActivityOrderDto order) {
                ActivityOrderPluginImpl.this.todayActivityStatisticsService.rollbackTodayConsumeCredits(order.getDuibaActivityId(), order.getActivityType(), order.getAppId(), order.getConsumeCredits());
            }

            @Override
            public void onOrderCreate(ActivityOrderDto order) {
                ActivityOrderPluginImpl.this.redisClientTool.setValue(order.getConsumerId(), order.getDuibaActivityId(), order.getActivityType(), order.getOrderNum());
                ActivityOrderPluginImpl.this.todayActivityStatisticsService.addTodayConsumeCredits(order.getDuibaActivityId(), order.getActivityType(), order.getAppId(), order.getConsumeCredits());
            }
        });
    }
}

