/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.remoteservice.impl;

import cn.com.duiba.activity.center.api.dto.ActivityCategoryDto;
import cn.com.duiba.activity.center.api.dto.CategoryActivityDto;
import cn.com.duiba.activity.center.api.remoteservice.RemoteActivityCategoryBackendService;
import cn.com.duiba.activity.center.biz.entity.ActivityCategoryEntity;
import cn.com.duiba.activity.center.biz.entity.ActivityCategoryRelationEntity;
import cn.com.duiba.activity.center.biz.service.ActivityCategoryRelationService;
import cn.com.duiba.activity.center.biz.service.ActivityCategoryService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remoteActivityCategoryBackendService")
public class RemoteActivityCategoryBackendServiceImpl
implements RemoteActivityCategoryBackendService {
    private static final Logger log = LoggerFactory.getLogger(RemoteActivityCategoryBackendServiceImpl.class);
    @Autowired
    private ActivityCategoryService activityCategoryService;
    @Autowired
    private ActivityCategoryRelationService activityCategoryRelationService;

    public DubboResult<Long> createCategory(String name) {
        try {
            Long id = this.activityCategoryService.createCategory(name);
            return DubboResult.successResult((Object)id);
        }
        catch (Exception e) {
            log.error("createCategory name=" + name, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> editCategoryContent(long id, String content) {
        try {
            Boolean ret = this.activityCategoryService.editCategoryContent(id, content);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            log.error("editCategoryContent id=" + id + ",content=" + content, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> enableCategory(long id) {
        try {
            Boolean ret = this.activityCategoryService.enableCategory(id);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            log.error("enableCategory id=" + id, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> disableCategory(long id) {
        try {
            Boolean ret = this.activityCategoryService.disableCategory(id);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            log.error("disableCategory id=" + id, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<ActivityCategoryDto>> findAll() {
        try {
            ArrayList<ActivityCategoryDto> ret = new ArrayList<ActivityCategoryDto>();
            List<ActivityCategoryEntity> list = this.activityCategoryService.findAll();
            for (ActivityCategoryEntity e : list) {
                ActivityCategoryDto dto = new ActivityCategoryDto();
                dto.setId(e.getId());
                dto.setName(e.getName());
                dto.setEnable(e.getEnable());
                dto.setContent(e.getContent());
                ret.add(dto);
            }
            return DubboResult.successResult(ret);
        }
        catch (Exception e) {
            log.error("findAll", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<ActivityCategoryDto> findDefaultCategory() {
        try {
            ActivityCategoryEntity e = this.activityCategoryService.findDefaultCategory();
            if (e == null) {
                return DubboResult.failResult((String)"\u6ca1\u6709\u9ed8\u8ba4\u5206\u7c7b");
            }
            ActivityCategoryDto dto = new ActivityCategoryDto();
            dto.setId(e.getId());
            dto.setName(e.getName());
            dto.setEnable(e.getEnable());
            dto.setContent(e.getContent());
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            log.error("findDefaultCategory", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<CategoryActivityDto>> findAllActivitiesByAppCategory(long appId, long categoryId) {
        try {
            List<ActivityCategoryRelationEntity> acrs = this.activityCategoryRelationService.findByAppCategory(appId, categoryId);
            ArrayList<CategoryActivityDto> dtos = new ArrayList<CategoryActivityDto>();
            if (acrs != null && acrs.size() > 0) {
                for (ActivityCategoryRelationEntity acr : acrs) {
                    CategoryActivityDto dto = new CategoryActivityDto();
                    dto.setId(acr.getId());
                    dto.setOperatingId(acr.getOperatingActivityId());
                    dto.setPayload(acr.getPayload());
                    dto.setAppId(Long.valueOf(appId));
                    dto.setCategoryId(Long.valueOf(categoryId));
                    dtos.add(dto);
                }
            }
            return DubboResult.successResult(dtos);
        }
        catch (Exception e) {
            log.error("findAllActivitiesByAppCategory error,appId=" + appId + ",categoryId=" + categoryId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> sortActivitiesByAppCategory(long appId, long categoryId, List<CategoryActivityDto> activities) {
        try {
            if (this.activityCategoryRelationService.sortActivities(activities)) {
                return DubboResult.successResult((Object)true);
            }
            return DubboResult.failResult((String)"\u66f4\u65b0\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("sortActivitiesByAppCategory error,appId=" + appId + ",categoryId=" + categoryId + ",activities is list", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> saveActivityCategoryRelation(CategoryActivityDto dto) {
        Long appId = dto.getAppId();
        Long categoryId = dto.getCategoryId();
        Long oaId = dto.getOperatingId();
        Integer payload = dto.getPayload();
        if (appId == null) {
            return DubboResult.failResult((String)"appId \u4e0d\u5f97\u4e3a\u7a7a");
        }
        if (categoryId == null) {
            return DubboResult.failResult((String)"categoryId \u4e0d\u5f97\u4e3a\u7a7a");
        }
        if (oaId == null) {
            return DubboResult.failResult((String)"operatingActivityId \u4e0d\u5f97\u4e3a\u7a7a");
        }
        if (payload == null) {
            return DubboResult.failResult((String)"payload \u4e0d\u5f97\u4e3a\u7a7a");
        }
        ActivityCategoryRelationEntity entity = new ActivityCategoryRelationEntity();
        try {
            entity.setAppId(appId);
            entity.setCategoryId(categoryId);
            entity.setOperatingActivityId(oaId);
            entity.setPayload(payload);
            if (this.activityCategoryRelationService.save(entity)) {
                return DubboResult.successResult((Object)true);
            }
            return DubboResult.failResult((String)("saveActivityCategoryRelation error,appId=" + appId + ",categoryId=" + categoryId + ",operatingActivityId=" + oaId + ",payload" + payload));
        }
        catch (Exception e) {
            log.error("saveActivityCategoryRelation error,appId=" + appId + ",categoryId=" + categoryId + ",operatingActivityId=" + oaId + ",payload" + payload, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> removeActivityCategoryRelation(Long operatingActivityId) {
        if (operatingActivityId == null) {
            return DubboResult.failResult((String)"operatingActivityId \u4e0d\u5f97\u4e3a\u7a7a");
        }
        try {
            if (this.activityCategoryRelationService.remove(operatingActivityId)) {
                return DubboResult.successResult((Object)true);
            }
            return DubboResult.failResult((String)"\u5220\u9664\u5931\u8d25");
        }
        catch (Exception e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<CategoryActivityDto> findActivityCategoryRelation(Long operatingActivityId) {
        try {
            CategoryActivityDto dto;
            ActivityCategoryRelationEntity rs = this.activityCategoryRelationService.findByOperatingActivityId(operatingActivityId);
            if (rs == null) {
                dto = null;
            } else {
                dto = new CategoryActivityDto();
                dto.setId(rs.getId());
                dto.setAppId(rs.getAppId());
                dto.setCategoryId(rs.getCategoryId());
                dto.setOperatingId(rs.getOperatingActivityId());
                dto.setPayload(rs.getPayload());
            }
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            log.error("findActivityCategoryRelation error,operatingActivityId=" + operatingActivityId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

