package cn.com.duiba.activity.center.biz.bo.game;

import cn.com.duiba.activity.center.api.dto.PaginationDto;
import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionRecordDto;
import cn.com.duiba.activity.center.biz.dao.DsConstants;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionBankService;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionRecordService;
import cn.com.duiba.service.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Created by wenqi.huang on 16/6/3.
 */
@Service
public class DuibaQuestionRecordBo {
    @Autowired
    private DuibaQuestionRecordService duibaQuestionRecordService;
    @Autowired
    private DuibaQuestionBankService duibaQuestionBankService;

    @Transactional(DsConstants.DATABASE_CREDITS_GAME)
    public void insert_manager(DuibaQuestionRecordDto questionRecordDO) throws BusinessException {
        duibaQuestionRecordService.insert(questionRecordDO);
        int result = duibaQuestionBankService.updateNumberAdd(questionRecordDO.getBankId());
        if(result!=1){
            throw new BusinessException("答题增加题库数目出错了");
        }
    }

    public PaginationDto<DuibaQuestionRecordDto> findByPage_manager(Long questionBankId, Integer offset, Integer max) {
        PaginationDto<DuibaQuestionRecordDto> page = new PaginationDto<DuibaQuestionRecordDto>();
        List<DuibaQuestionRecordDto> rows = duibaQuestionRecordService.findByPage(questionBankId, offset, max);
        page.setRows(rows);
        page.setTotalCount(duibaQuestionRecordService.findTotalCount(questionBankId));
        return page;
    }

    @Transactional(DsConstants.DATABASE_CREDITS_GAME)
    public void delete_manager(Long id) throws BusinessException {
        DuibaQuestionRecordDto duibaQuestionRecordDO = duibaQuestionRecordService.findById(id);
        int result = duibaQuestionBankService.updateNumberSub(duibaQuestionRecordDO.getBankId());
        if(result!=1){
            throw new BusinessException("答题减少题库数目出错了");
        }
        result = duibaQuestionRecordService.delete(id);
        if(result!=1){
            throw new BusinessException("答题删除题库数目出错了");
        }
    }

}
